/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.encrypt;

import com.xunlei.channel.common.utils.encrypt.RSA;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RSAEncrypt
extends RSA {
    private static final Logger logger = LoggerFactory.getLogger(RSAEncrypt.class);
    public static final String KEY_ALGORITHM = "RSA";
    public static final String ENCODING = "utf-8";

    public static byte[] encryptByPublicKey(byte[] bytes, String publicKey) {
        try {
            PublicKey pubKey = RSAEncrypt.getPublicKey(publicKey);
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
            cipher.init(1, pubKey);
            byte[] cipherData = cipher.doFinal(bytes);
            return cipherData;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("sign error, content: {}, pubKey: {}", (Object)bytes, (Object)publicKey);
            logger.error("sign error", (Throwable)e);
            return null;
        }
    }

    public static byte[] decryptByPrivateKey(byte[] bytes, String privateKey) {
        try {
            PrivateKey priKey = RSAEncrypt.getPrivateKey(privateKey);
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
            cipher.init(2, priKey);
            byte[] plain = cipher.doFinal(bytes);
            return plain;
        }
        catch (Exception e) {
            logger.error("sign error, content: {}, pubKey: {}", (Object)bytes, (Object)privateKey);
            logger.error("sign error", (Throwable)e);
            return null;
        }
    }

    public static int maxCipherLength(PrivateKey privateKey) {
        int i = RSAEncrypt.keySize((RSAKey)((Object)privateKey));
        return i;
    }

    public static int maxPlainTextLength(PublicKey publicKey) {
        int i = RSAEncrypt.keySize((RSAKey)((Object)publicKey));
        return i - 11;
    }

    public static int getByteLength(BigInteger modulus) {
        int var1 = modulus.bitLength();
        return var1 + 7 >> 3;
    }

    public static int keySize(RSAKey rsaKey) {
        BigInteger modulus = rsaKey.getModulus();
        int byteLength = RSAEncrypt.getByteLength(modulus);
        return byteLength;
    }
}

