package com.xunlei.channel.common.utils.json;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * 使用jsonlib.jar来解析生成json 需要引入jsonlib.jar和ezmorph-1.0.6.jar
 * 
 * @author huangchunhui 2014年6月3日 下午8:07:36
 */
public class JsonUtil {

    /**
     * 从一个JSON对象字符格式中得到一个java对象 说明：Bean的无参构造函数一定要写, 否则会报异常
     * 
     * @param json
     * @param clazz
     * @return
     */
    public static <T> T jsonToObject(String json, Class<T> clazz) {
        return JSON.parseObject(json, clazz);
    }

    /**
     * 将java对象转换成json字符串
     * 
     * @param obj
     * @return
     */
    public static String objectToJson(Object obj) {
        return JSON.toJSONString(obj);
    }

    /**
     * 从json HASH表达式中获取一个map
     * 
     * @param json
     * @return
     */
    public static Map<String, Object> jsonToMap(String json) {
        JSONObject jsonObject = JSON.parseObject(json);
        Map<String, Object> map = new HashMap<String, Object>();
        for (Entry<String, Object> en : jsonObject.entrySet()) {
            map.put(en.getKey(), en.getValue());
        }
        return map;
    }

    /**
     * 从Map对象得到Json字串
     * 
     * @param map
     * @return
     */
    public static String mapToJson(Map<String, Object> map) {
        return JSON.toJSONString(map);
    }

    /**
     * 从json字串中得到相应java数组
     * 
     * @param jsonString like "[\"李斯\",100]"
     * @return
     */
    public static Object[] jsonToArray(String json) {
        JSONArray jsonArray = JSON.parseArray(json);
        return jsonArray.toArray();
    }

}
