/**
 * Project: gateway-pay
 * File Created at 2016年4月20日
 * ouyangjixin
 * Copyright 2014 XunLei.com Corporation Limited.
 * All rights reserved.
 * This software is the confidential and proprietary information of
 * XunLei Company. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with XunLei.com.
 */
package com.xunlei.channel.common.utils.http;

import org.apache.http.*;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @author xiongyingqi
 * @since 2016-09-18
 */
public abstract class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    public static final String DEFAULT_CHARSET = "UTF-8";

    public static String getUrl(String domain, String path) {
        if (path == null) {
            return domain;
        }
        StringBuilder builder = new StringBuilder();
        if (!domain.contains("://")) {
            builder.append("http://");
        }
        builder.append(domain);
        if (!path.startsWith("/")) {
            builder.append("/");
        }
        builder.append(path);

        return builder.toString();
    }



    /**
     * @param request
     * @return
     */
    public static String executeRequest(HttpRequestBase request, String charset, int timeout) {
        if (charset == null || "".equals(charset)) {
            charset = DEFAULT_CHARSET;
        }
        HttpResponse response = null;
        String result = null;
        HttpClient client = ClientFactory.getClient();
        try {
            if (client == null) {
                logger.error("Failed to get httpclient!");
                return null;
            }
            RequestConfig requestConfig = RequestConfig.custom()
                    .setConnectTimeout(timeout)
                    .setSocketTimeout(timeout)
                    .setConnectionRequestTimeout(timeout)
                    .build();
            request.setConfig(requestConfig);

            response = client.execute(request);
            if (response == null) {
                logger.error("response is null!");
                return null;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                logger.error("statusCode: {}", statusCode);
                return null;
            }
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString(entity, charset);
            if (logger.isDebugEnabled()) {
                logger.debug("Execute request: {} and returns: {}", request, result);
            }
        } catch (Exception e) {
            logger.error("Http error with message: " + e.getMessage(), e);
            return null;
        }
        return result;
    }

    public static String readResponse(HttpResponse response, String charset) throws IOException {
        if (response == null) {
            logger.error("response is null!");
            return null;
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != HttpStatus.SC_OK) {
            logger.error("statusCode: {}", statusCode);
            return null;
        }
        HttpEntity entity = response.getEntity();
        String result = EntityUtils.toString(entity, charset);
        return result;
    }


    /**
     * @param postUrl
     * @param reqEntity
     * @return
     */
    public static String post(String postUrl, HttpEntity reqEntity, String charset, int timeout) {
        HttpPost httpPost = new HttpPost(postUrl);
        httpPost.setEntity(reqEntity);
        String response = executeRequest(httpPost, charset, timeout);
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("Sent post to url: {} with request: {}", postUrl, EntityUtils.toString(reqEntity,
                        charset));
            } catch (IOException e) {
                logger.error("", e);
            }
        }
        return response;
    }

    public static String post(String postUrl, String content, String charset, int timeout) {
        StringEntity entity = new StringEntity(content, charset);
        entity.setContentType(URLEncodedUtils.CONTENT_TYPE);
        return post(postUrl, entity, charset, timeout);
    }

    public static String buildUrlParams(String url,
                                        Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return url;
        }
        StringBuilder builder = new StringBuilder(url);
        if (!url.contains("?")) {
            builder.append("?");
        } else {
            builder.append("&");
        }
        String httpParameters = parseMapToHttpParameters(params);
        builder.append(httpParameters);

        String substring = builder.substring(0, builder.length());
        return substring;
    }

    public static String parseMapToHttpParameters(Map<String, String> parameters) {
        StringBuilder builder = new StringBuilder();
        for (Iterator<Map.Entry<String, String>> iterator = parameters.entrySet().iterator(); iterator
                .hasNext(); ) {
            Map.Entry<String, String> entry = iterator.next();
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null || "".equals(key)) {
                continue;
            }
            builder.append(key);
            builder.append("=");
            builder.append(value);
            if (iterator.hasNext()) {
                builder.append("&");
            }
        }
        return builder.toString();
    }

    public static List<NameValuePair> parseMapToPairs(Map<String, String> parameters) {
        if (parameters == null) {
            return null;
        }
        List<NameValuePair> pairs = new ArrayList<NameValuePair>(parameters.size());
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            NameValuePair pair = new BasicNameValuePair(key, value);
            pairs.add(pair);
        }
        return pairs;
    }
}
