package com.xunlei.channel.common.utils.carriers;

import com.google.common.base.Strings;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xiongyingqi
 * @since 16-12-2 下午2:27
 */
public abstract class CarriersUtils {
    public static final String CARRIERS_DELIMITER = ",";

    public static MobileCarriers[] parseCarriers(String carriers) {
        if (Strings.isNullOrEmpty(carriers)) {
            return null;
        }

        String[] carriersArray = carriers.split(CARRIERS_DELIMITER);
        List<MobileCarriers> carriersList = new ArrayList<MobileCarriers>(carriersArray.length);
        for (String carrierString : carriersArray) {
            MobileCarriers smsCarriers = MobileCarriers.valueOf(carrierString.trim());
            carriersList.add(smsCarriers);
        }

        return carriersList.toArray(new MobileCarriers[carriersList.size()]);
    }



}
