package com.xunlei.channel.common.utils.string;

import com.xunlei.channel.common.utils.date.DateUtils;

import java.util.Random;


/**
 * 字符处理工具类
 * 
 * @author huangchunhui 2014年6月3日 下午5:18:20
 */
public class StringUtil {

    /**
     * 检测字符串能否转换成long
     * 
     * @param str
     * @return
     */
    public static boolean canParseLong(String str) {
        try {
            Long.parseLong(str);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    /**
     * 检测字符串能否转换成int
     * 
     * @param str
     * @return
     */
    public static boolean canParseInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    /**
     * 返回一个定长的随机字符串(只包含数字)
     * 
     * @param length 随机字符串长度
     * @return 随机字符串
     */
    public static String generateString(int length) {
        final String numberChar = "0123456789";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; i++) {
            Random random = new Random();
            int randomInt = random.nextInt();
            if (randomInt < 0) {
                randomInt = -randomInt;
            }
            int randomIndex = randomInt % numberChar.length();
            sb.append(numberChar.charAt(randomIndex));
        }
        return sb.toString();
    }

    /**
     * 检测字符串是否为数字
     * 
     * @param str
     * @return true是 false否
     */
    public static boolean isDigit(String str) {
        boolean isDigit = false;
        try {
            if (null == str || "".equals(str)) {
            } else {
                Integer.parseInt(str);
                isDigit = true;
            }
        } catch (Exception e) {
        }
        return isDigit;
    }

    /**
     * 检查指定参数是否存在SQL注入漏洞
     * 
     * @param param
     * @return true通过 false不通过
     */
    public static boolean checkSqlInject(String param) {
        final String INJ_STR = "`|'|and|exec|insert|select|delete|update|count|%|chr|mid|master|truncate|char|declare|; |or|-|+|,";
        if (null == param || "".equals(param)) {
            return true;
        }
        String keyWords[] = INJ_STR.split("\\|");
        for (int i = 0; i < keyWords.length; i++) {
            if (param.contains(keyWords[i])) {
                return false;
            }
        }
        return true;
    }

    /**
     * 生成永不重复的流水号,规则为yyyyMMddHHmmss加上6位随机数字,总共20位
     * 
     * @return
     */
    public static String generateSerialNumber() {
        return DateUtils.getCurrentTime(DateUtils.SP2) + generateString(6);
    }

}
