package com.xunlei.channel.common.utils.http;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;

import java.util.concurrent.TimeUnit;

/**
 * @author xiongyingqi
 * @since 2018/1/18
 */
public class ClientFactory {
    public static final int DEFAULT_TIMEOUT = 6000;

    private static ConnectionKeepAliveStrategy myStrategy = new DefaultConnectionKeepAliveStrategy() {

        @Override
        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            long keepAliveDuration = super.getKeepAliveDuration(response, context);
            if (keepAliveDuration == -1) {
                return 10 * DEFAULT_TIMEOUT;
            }
            return keepAliveDuration;
        }
    };

    public static CloseableHttpClient newClient(int timeout) {
        // 不允许设置不超时连接
        if (timeout <= 0) {
            timeout = DEFAULT_TIMEOUT;
        }
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder = requestBuilder.setSocketTimeout(timeout);
        requestBuilder.setConnectTimeout(timeout);
        requestBuilder.setConnectionRequestTimeout(timeout);

        CloseableHttpClient client = HttpClientBuilder
                .create()
                .setMaxConnTotal(200)
                .setMaxConnPerRoute(20)
                .setDefaultRequestConfig(requestBuilder.build())
                .setKeepAliveStrategy(myStrategy)
                // only from 4.4
//                .setConnectionTimeToLive(60, TimeUnit.SECONDS)
                .build();

        return client;

    }

    private static HttpClient newClient() {
        return newClient(DEFAULT_TIMEOUT);
    }

    private ClientFactory() {
    }

    private static class InstanceHolder {
        private static final HttpClient INSTANCE = newClient();
    }

    public static HttpClient getClient() {
        return InstanceHolder.INSTANCE;
    }


}
