package com.xunlei.channel.common.utils.carriers;

import java.util.HashSet;

/**
 * 短信运营商。<br>
 * 例如： 移动、联通、电信
 *
 * @author xiongyingqi
 * @since 16-10-19 下午3:03
 */
public enum MobileCarriers {
    MOBILE("MOBILE"), UNICOM("UNICOM"), TELECOM("TELECOM");
    MobileCarriers(String carriers){
        this.carriers = carriers;
    }
    private String carriers;

    public String getCarriers() {
        return carriers;
    }

    public static boolean isSupportAll(MobileCarriers[] smsCarriersArray) {
        HashSet<MobileCarriers> smsCarriersSet = new HashSet<MobileCarriers>();
        for (MobileCarriers smsCarriers : smsCarriersArray) {
            smsCarriersSet.add(smsCarriers);
        }
        for (MobileCarriers smsCarriers : values()) {
            if (!smsCarriersSet.contains(smsCarriers)) {
                return false;
            }
        }
        return true;
    }
}
