package com.xunlei.channel.common.utils.arith;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;

/**
 * 单位转换工具类
 * 
 * @author huangchunhui 2014-1-16 上午10:18:19
 */
public class UnitArith {

    /**
     * 分变元,并保留两位小数
     * 
     * @param amount
     * @return
     */
    public static String fenToyuan(String amount) {
        double res = new BigDecimal(amount).movePointLeft(2).doubleValue();
        NumberFormat formatter = new DecimalFormat("0.00");
        return formatter.format(res);
    }

    /**
     * 分变元,并保留两位小数
     * 
     * @param amount
     * @return
     */
    public static String fenToyuan(double amount) {
        double res = new BigDecimal(amount + "").movePointLeft(2).doubleValue();// 使用String来构造,否则会出现小数
        NumberFormat formatter = new DecimalFormat("0.00");
        return formatter.format(res);
    }

    /**
     * 元变分,并保留两位小数
     * 
     * @param amount
     * @return
     */
    public static String yuanTofen(String amount) {
        double res = new BigDecimal(amount).movePointRight(2).doubleValue();
        NumberFormat formatter = new DecimalFormat("0");
        return formatter.format(res);
    }

    /**
     * 元变分,并保留两位小数
     * 
     * @param amount
     * @return
     */
    public static String yuanTofen(double amount) {
        double res = new BigDecimal(amount + "").movePointRight(2).doubleValue();// 使用String来构造,否则会出现小数
        NumberFormat formatter = new DecimalFormat("0");
        return formatter.format(res);
    }
}
