/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.sequence;

import com.xunlei.channel.common.utils.network.NetWorkUtils;
import com.xunlei.channel.common.utils.string.StringUtils;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SequenceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SequenceGenerator.class);
    private static final String FORMAT_STRING = "yyyyMMddHHmmssSSS";
    private static AtomicInteger index = new AtomicInteger();
    private static String widthMachineNumber = "";

    private static String getIndexString(int width) {
        int max = (int)Math.pow(10.0, width) - 1;
        int number = index.getAndIncrement();
        int rs = number % max;
        if (rs < 0) {
            rs = -rs;
        }
        return StringUtils.fillZero(rs + "", width);
    }

    public static String getMachineNumberBySequence(String sequence) {
        String machineNumber = sequence.substring(17, 27);
        return machineNumber;
    }

    public static String generateSequence() {
        return SequenceGenerator.generateSequence(1000000);
    }

    public static String generateSequence(int concurrent) {
        StringBuilder builder = new StringBuilder();
        String dateString = SequenceGenerator.getDateString();
        builder.append(dateString);
        builder.append(widthMachineNumber);
        double log = Math.log10(concurrent);
        String indexString = SequenceGenerator.getIndexString((int)log);
        builder.append(indexString);
        return builder.toString();
    }

    private static String getDateString() {
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_STRING);
        String date = format.format(new Date());
        return date;
    }

    static {
        try {
            widthMachineNumber = NetWorkUtils.getWidthMachineNumber();
        }
        catch (UnknownHostException e) {
            logger.error("", (Throwable)e);
        }
    }
}

