/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.carriers;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.xunlei.channel.common.utils.carriers.MobileCarriers;
import com.xunlei.channel.common.utils.carriers.MobileCarriersConfigService;
import com.xunlei.channel.common.utils.carriers.config.MobileCarriersPropertiesConfigService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarriersStatementSupport {
    private static final Logger logger = LoggerFactory.getLogger(CarriersStatementSupport.class);
    private MobileCarriersConfigService mobileCarriersConfigService;
    private Map<String, MobileCarriers> carriersStatementsMap = new HashMap<String, MobileCarriers>();
    private int maxStatementLength;
    private AtomicBoolean locked = new AtomicBoolean(false);

    public CarriersStatementSupport(MobileCarriersConfigService mobileCarriersConfigService) {
        this.mobileCarriersConfigService = mobileCarriersConfigService;
        this.reloadConfig();
    }

    public CarriersStatementSupport() {
        this(new MobileCarriersPropertiesConfigService());
    }

    public Optional<MobileCarriers> findCarriersByMobile(String mobile) {
        if (Strings.isNullOrEmpty((String)mobile)) {
            return Optional.absent();
        }
        while (this.locked.get()) {
            logger.warn("Carriers map is locked, so waiting for unlock.");
        }
        for (int statementLength = this.maxStatementLength; statementLength > 0; --statementLength) {
            String statement = mobile.substring(0, statementLength);
            MobileCarriers smsCarriers = this.carriersStatementsMap.get(statement);
            if (smsCarriers == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Found MobileCarriers: {} by mobile: {}", (Object)smsCarriers, (Object)mobile);
            }
            return Optional.of((Object)((Object)smsCarriers));
        }
        logger.warn("Could'nt found carriers by mobile: {}", (Object)mobile);
        return Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reloadConfig() {
        while (!this.locked.compareAndSet(false, true)) {
            logger.warn("Another thread is locked, so waiting for unlock.");
        }
        try {
            this.carriersStatementsMap.clear();
            String mobileStatementConfig = this.mobileCarriersConfigService.getCarriersMobileStatementConfig();
            String unicomStatementConfig = this.mobileCarriersConfigService.getCarriersUnicomStatementConfig();
            String telecomStatementConfig = this.mobileCarriersConfigService.getCarriersTelecomStatementConfig();
            boolean mobileOk = this.loadMobileStatement(MobileCarriers.MOBILE, mobileStatementConfig);
            boolean unicomOk = this.loadMobileStatement(MobileCarriers.UNICOM, unicomStatementConfig);
            boolean telecomOk = this.loadMobileStatement(MobileCarriers.TELECOM, telecomStatementConfig);
            this.loadMaxStatementLength();
            boolean bl = mobileOk || unicomOk || telecomOk;
            return bl;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.locked.compareAndSet(true, false);
        }
    }

    private void loadMaxStatementLength() {
        this.maxStatementLength = -1;
        Set<String> keySet = this.carriersStatementsMap.keySet();
        for (String statement : keySet) {
            int length = statement.length();
            if (length <= this.maxStatementLength) continue;
            this.maxStatementLength = length;
        }
    }

    private boolean loadMobileStatement(MobileCarriers carriers, String statementConfig) {
        Optional<List<String>> optional = this.parseStatementConfig(statementConfig);
        if (!optional.isPresent()) {
            logger.error("No mobile carriers statement found!");
            return false;
        }
        List list = (List)optional.get();
        for (String statement : list) {
            this.carriersStatementsMap.put(statement, carriers);
        }
        return true;
    }

    private Optional<List<String>> parseStatementConfig(String statementConfig) {
        String[] statements;
        if (Strings.isNullOrEmpty((String)statementConfig)) {
            return Optional.absent();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String statement : statements = statementConfig.split(",")) {
            result.add(statement.trim());
        }
        return Optional.of(result);
    }
}

