package com.xunlei.channel.common.utils.encrypt;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * @author qi
 * @since 2017/12/17
 */
public abstract class Sha512Encrypt {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String ALGORITHM = "SHA-512";
    private static final Logger logger = LoggerFactory.getLogger(Sha512Encrypt.class);

    public static String sha512Encrypt(String message, String salt) {
        return sha512Encrypt(message, salt, DEFAULT_CHARSET);
    }

    public static String sha512Encrypt(String message, String salt, String charset) {
        String digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM);
            md.update(salt.getBytes(charset));
            byte[] bytes = md.digest(message.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < bytes.length; i++) {
                String hex = Integer.toHexString(0xff & bytes[i]);
                if (hex.length() == 1) {
                    sb.append('0');
                }
                sb.append(hex);
            }
            digest = sb.toString();
        } catch (Exception e) {
            logger.error("", e);
        }
        return digest;
    }

}
