package com.xunlei.channel.common.utils.encrypt;

import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.util.encoders.UrlBase64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

/**
 * @author xiongyingqi
 * @since 2017/12/28
 */
public abstract class RSAEncrypt extends RSA {
    private static final Logger logger = LoggerFactory.getLogger(RSAEncrypt.class);
    public static final String KEY_ALGORITHM = "RSA";
    public static final String ENCODING = "utf-8";

    /**
     * RSA加密
     *
     * @param bytes     待签名数据原始串
     * @param publicKey 公钥
     * @return true通过 false失败
     */
    public static byte[] encryptByPublicKey(byte[] bytes, String publicKey) {
        try {
            PublicKey pubKey = getPublicKey(publicKey);
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
            cipher.init(Cipher.ENCRYPT_MODE, pubKey);
            byte[] cipherData = cipher.doFinal(bytes);
            return cipherData;
        } catch (Exception e) {
            logger.error("sign error, content: {}, pubKey: {}", bytes, publicKey);
            logger.error("sign error", e);
            return null;
        }
    }

    /**
     * RSA解密
     *
     * @param bytes      密文
     * @param privateKey 私钥
     * @return true通过 false失败
     */
    public static byte[] decryptByPrivateKey(byte[] bytes, String privateKey) {
        try {
            PrivateKey priKey = getPrivateKey(privateKey);
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
            cipher.init(Cipher.DECRYPT_MODE, priKey);
            byte[] plain = cipher.doFinal(bytes);
            return plain;
        } catch (Exception e) {
            logger.error("sign error, content: {}, pubKey: {}", bytes, privateKey);
            logger.error("sign error", e);
            return null;
        }
    }


    public static int maxCipherLength(PrivateKey privateKey) {
        int i = keySize((RSAKey) privateKey);
        return i;
    }

    public static int maxPlainTextLength(PublicKey publicKey) {
        int i = keySize((RSAKey) publicKey);
        return i - 11;
    }

    public static int getByteLength(BigInteger modulus) {
        int var1 = modulus.bitLength();
        return var1 + 7 >> 3;
    }

    public static int keySize(RSAKey rsaKey){
        BigInteger modulus = rsaKey.getModulus();
        int byteLength = getByteLength(modulus);
        return byteLength;
    }

}
