package com.xunlei.channel.common.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;

import java.io.IOException;

/**
 * @author xiongyingqi
 * @since 16-6-8 下午5:34
 */
public abstract class XmlHelper {
    //    private static  final ObjectMapper mapper = newMapper();
    static final ThreadLocal<XmlMapper> mapper = new ThreadLocal<XmlMapper>() {
        @Override
        protected XmlMapper initialValue() {
            return newConfiguredMapper();
        }
    };

    public static String getXmlString(Object o) {
        XmlMapper mapper = newMapper();
        try {
            return mapper.writeValueAsString(o);
        } catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T> T convertXmlByClass(String json, Class<T> clazz) throws IOException {
        XmlMapper mapper = newMapper();
        return mapper.readValue(json, clazz);
    }


    public static XmlMapper newConfiguredMapper() {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        xmlMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        return xmlMapper;
    }

    public static XmlMapper newMapper() {
//        ObjectMapper objectMapper = new ObjectMapper();
//        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
//        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
//        return objectMapper;
        return mapper.get();
    }
}
