/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.encrypt;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.util.encoders.UrlBase64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSASignature {
    private static final Logger LOG = LoggerFactory.getLogger(RSASignature.class);
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA1WithRSA";
    public static final String ENCODING = "utf-8";
    public static final String X509 = "X.509";

    public static PrivateKey getPrivateKey(String key) throws Exception {
        byte[] keyBytes = RSASignature.buildPKCS8Key(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static PublicKey getPublicKey(String key) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        key = RSASignature.getKey(key);
        byte[] encodedKey = UrlBase64.decode((byte[])key.getBytes(ENCODING));
        PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
        return pubKey;
    }

    public static String signByPrivateKey(String content, String privateKey) {
        try {
            PrivateKey priKey = RSASignature.getPrivateKey(privateKey);
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initSign(priKey);
            signature.update(content.getBytes(ENCODING));
            byte[] signed = signature.sign();
            return new String(UrlBase64.encode((byte[])signed), ENCODING);
        }
        catch (Exception e) {
            LOG.error("sign error, content: {}, priKey: {}", new Object[]{content, privateKey});
            LOG.error("sign error", (Throwable)e);
            return null;
        }
    }

    public static boolean verifySignByPublicKey(String content, String sign, String publicKey) {
        try {
            PublicKey pubKey = RSASignature.getPublicKey(publicKey);
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(ENCODING));
            return signature.verify(UrlBase64.decode((byte[])sign.getBytes(ENCODING)));
        }
        catch (Exception e) {
            LOG.error("sign error, content: {}, sign: {}, pubKey: {}", new Object[]{content, sign, publicKey});
            LOG.error("sign error", (Throwable)e);
            return false;
        }
    }

    public static boolean verifySignByPublicKey(String content, String sign, String publicKey, String ENCODING) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            byte[] encodedKey = UrlBase64.decode((byte[])publicKey.getBytes(ENCODING));
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(ENCODING));
            return signature.verify(UrlBase64.decode((byte[])sign.getBytes(ENCODING)));
        }
        catch (Exception e) {
            LOG.error("sign error, content: {}, sign: {}, pubKey: {}", new Object[]{content, sign, publicKey});
            LOG.error("sign error", (Throwable)e);
            return false;
        }
    }

    private static byte[] buildPKCS8Key(String privateKey) throws IOException {
        if (privateKey.contains("-----BEGIN PRIVATE KEY-----")) {
            return Base64.decodeBase64((String)privateKey.replaceAll("-----\\w+ PRIVATE KEY-----", ""));
        }
        if (privateKey.contains("-----BEGIN RSA PRIVATE KEY-----")) {
            byte[] innerKey = Base64.decodeBase64((String)privateKey.replaceAll("-----\\w+ RSA PRIVATE KEY-----", ""));
            byte[] result = new byte[innerKey.length + 26];
            System.arraycopy(Base64.decodeBase64((String)"MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKY="), 0, result, 0, 26);
            System.arraycopy(BigInteger.valueOf(result.length - 4).toByteArray(), 0, result, 2, 2);
            System.arraycopy(BigInteger.valueOf(innerKey.length).toByteArray(), 0, result, 24, 2);
            System.arraycopy(innerKey, 0, result, 26, innerKey.length);
            return result;
        }
        return Base64.decodeBase64((String)privateKey);
    }

    public static String getKey(String content) throws Exception {
        return content.replaceAll("\\-{5}[\\w\\s]+\\-{5}[\\r\\n|\\n]", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readSourceKey(String path) {
        BufferedReader reader = null;
        StringBuffer sourceKey = new StringBuffer();
        try {
            reader = new BufferedReader(new FileReader(path));
            String part = reader.readLine();
            part = reader.readLine();
            while (part.charAt(0) != '-') {
                sourceKey.append(part + "\r");
                part = reader.readLine();
            }
        }
        catch (Exception e) {
            LOG.error("readSourceKey throws Exception:", (Throwable)e);
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
        return sourceKey.toString();
    }
}

