/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.arith;

import java.math.BigDecimal;

public abstract class Arith {
    private static final int DEF_DIV_SCALE = 2;

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static double div(double v1, double v2) {
        return Arith.div(v1, v2, 2);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static BigDecimal divide(BigDecimal dividend, BigDecimal divisor) {
        return Arith.divide(dividend, divisor, 2);
    }

    public static BigDecimal divide(BigDecimal dividend, BigDecimal divisor, int scale) {
        BigDecimal result = dividend.divide(divisor, scale, 4);
        return result;
    }

    public static BigDecimal add(BigDecimal addend, BigDecimal augend, int scale) {
        BigDecimal result = addend.add(augend);
        result = result.setScale(scale, 4);
        return result;
    }

    public static BigDecimal subtract(BigDecimal minuend, BigDecimal subtrahend, int scale) {
        BigDecimal result = minuend.subtract(subtrahend);
        result = result.setScale(scale, 4);
        return result;
    }

    public static BigDecimal multiply(BigDecimal multiplier, BigDecimal multiplicand, int scale) {
        BigDecimal result = multiplier.multiply(multiplicand);
        result = result.setScale(scale, 4);
        return result;
    }
}

