package com.xunlei.channel.common.utils.map;

import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

/**
 * 键值对工具类
 * 
 * @author huangchunhui 2014年6月3日 下午6:23:51
 */
public class KeyValueUtil {

    /**
     * 从Map中获取key=value字符串
     * <p>
     * 包含key为null或者"" 和 value为null或者"" 的属性
     * 
     * @param map
     * @return
     * @throws Exception 传入map为空时抛出异常
     */
    public static String getKeyValueStr(Map<String, Object> map) throws Exception {
        if (null == map) {
            throw new Exception("map is empty!");
        }
        Iterator<String> it = map.keySet().iterator();
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (it.hasNext()) {
            String key = it.next();
            Object value = map.get(key);
            if (isFirst) {
                sb.append(key).append("=").append(value);
                isFirst = false;
            } else {
                sb.append("&").append(key).append("=").append(value);
            }
        }
        return sb.toString();
    }

    /**
     * 从Map中获取key=value字符串
     * <p>
     * 跳过key为null或者"" 和 value为null或者"" 的属性
     * 
     * @param map
     * @return
     * @throws Exception 传入map为空时抛出异常
     */
    public static String getKeyValueStrTrim(Map<String, Object> map) throws Exception {
        if (null == map) {
            throw new Exception("map is empty!");
        }
        Iterator<String> it = map.keySet().iterator();
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (it.hasNext()) {
            String key = it.next();
            Object value = map.get(key);
            if (null != key && !"".equals(key) && null != value && !"".equals(value)) {
                if (isFirst) {
                    sb.append(key).append("=").append(value);
                    isFirst = false;
                } else {
                    sb.append("&").append(key).append("=").append(value);
                }
            }
        }
        return sb.toString();
    }

    /**
     * 从Map中获取key=value字符串(该方法value会带双引号)
     * <p>
     * 跳过key为null或者"" 和 value为null或者"" 的属性
     * 
     * @param map
     * @return
     * @throws Exception 传入map为空时抛出异常
     */
    public static String getKeyValueStrTrimWithMark(Map<String, Object> map) throws Exception {
        if (null == map) {
            throw new Exception("map is empty!");
        }
        Iterator<String> it = map.keySet().iterator();
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (it.hasNext()) {
            String key = it.next();
            Object value = map.get(key);
            if (null != key && !"".equals(key) && null != value && !"".equals(value)) {
                if (isFirst) {
                    sb.append(key).append("=").append("\"").append(value).append("\"");
                    isFirst = false;
                } else {
                    sb.append("&").append(key).append("=").append("\"").append(value).append("\"");
                }
            }
        }
        return sb.toString();
    }

    /**
     * 从Map中获取key=value字符串(跳过空值),并对value值进行urlencode编码
     * 
     * @param map
     * @return
     */
    public static String getKeyValueStrEnc(Map<String, String> map, String encoding) throws Exception {
        if (null == map) {
            throw new Exception("map is empty!");
        }
        if (null == encoding || "".equals(encoding)) {
            throw new Exception("encoding is illegal!");
        }
        Iterator<String> it = map.keySet().iterator();
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (it.hasNext()) {
            String key = it.next();
            String value = map.get(key);
            if (null != key && !"".equals(key) && null != value && !"".equals(value)) {
                String enValue = URLEncoder.encode(value, encoding);
                enValue.replace("+", "%20");
                if (isFirst) {
                    sb.append(key).append("=").append(enValue);
                    isFirst = false;
                } else {
                    sb.append("&").append(key).append("=").append(enValue);
                }
            }
        }
        return sb.toString();
    }

    /**
     * 从对象中获取key=value字符串,对象中的属性应该为基本数据类型或者重写toString方法的对象<br>
     * 跳过key为null或者"" 和 value为null或者"" 的属性<br>
     * 该方法会对参数进行字母顺序排序
     * 
     * @param obj
     * @return
     * @throws Exception
     */
    public static String getKeyValueStrTrim(Object obj) throws Exception {
        Field fields[] = obj.getClass().getDeclaredFields();
        Map<String, Object> paramMap = new TreeMap<String, Object>();
        for (int i = 0; i < fields.length; i++) {
            Field field = fields[i];
            field.setAccessible(true);
            String key = field.getName();
            Object value = field.get(obj);
            if (null == key || "".equals(key) || null == value || "".equals(value)) {
                continue;
            } else {
                paramMap.put(key, value);
            }
        }
        return getKeyValueStrTrim(paramMap);
    }

    /**
     * 从对象中获取key=value字符串,对象中的属性应该为基本数据类型或者重写toString方法的对象<br>
     * 跳过key为null或者"" 和 value为null或者"" 的属性<br>
     * 该方法会对参数进行字母顺序排序 该方法返回的value会带双引号
     * 
     * @param obj
     * @return
     * @throws Exception
     */
    public static String getKeyValueStrTrimWithMark(Object obj) throws Exception {
        Field fields[] = obj.getClass().getDeclaredFields();
        Map<String, Object> paramMap = new TreeMap<String, Object>();
        for (int i = 0; i < fields.length; i++) {
            Field field = fields[i];
            field.setAccessible(true);
            String key = field.getName();
            Object value = field.get(obj);
            if (null == key || "".equals(key) || null == value || "".equals(value)) {
                continue;
            } else {
                paramMap.put(key, value);
            }
        }
        return getKeyValueStrTrimWithMark(paramMap);
    }
}
