package com.xunlei.channel.common.utils.exception;

/**
 * 自定义异常
 * 
 * @author huangchunhui 2014年6月3日 下午2:38:08
 */
public class CommonException extends Exception {

    private static final long serialVersionUID = 4010077977363713311L;

    /**
     * 错误码
     */
    private String errCode;

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public CommonException(String errCode, String errMsg) {
        super(errMsg);
        this.errCode = errCode;
    }

    @Override
    public String toString() {
        StringBuffer exceptionMsg = new StringBuffer();
        exceptionMsg.append(this.getClass().getName()).append("[errCode=").append(getErrCode()).append(" errMsg=").append(getMessage()).append("] ");
        StackTraceElement[] stackTraceElements = this.getStackTrace();
        for (StackTraceElement element : stackTraceElements) {
            exceptionMsg.append(element + "\n\t");
        }
        return exceptionMsg.toString();
    }
}
