/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.scan;

import com.xunlei.channel.common.utils.Assert;
import com.xunlei.channel.common.utils.CollectionUtils;
import com.xunlei.channel.common.utils.scan.ClassLookupHelper;
import com.xunlei.channel.common.utils.string.StringUtils;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageScanner {
    private Collection<Package> packages;
    private Collection<Class<? extends Annotation>> orAnnotations;
    private Collection<Class<? extends Annotation>> andAnnotations;
    private Collection<String> startWithStrings;
    private Collection<String> endWithStrings;
    private Collection<Class<?>> orImplementsInterface;
    private Collection<Class<?>> andImplementsInterface;
    private boolean recursive;
    private boolean ignoreInterface;

    private PackageScanner() {
    }

    public static PackageScanner newScanner() {
        PackageScanner packageScanner = new PackageScanner();
        packageScanner.packages = new ArrayList<Package>();
        packageScanner.orAnnotations = new ArrayList<Class<? extends Annotation>>();
        packageScanner.andAnnotations = new ArrayList<Class<? extends Annotation>>();
        packageScanner.startWithStrings = new ArrayList<String>();
        packageScanner.endWithStrings = new ArrayList<String>();
        packageScanner.orImplementsInterface = new ArrayList();
        packageScanner.andImplementsInterface = new ArrayList();
        packageScanner.recursive = true;
        packageScanner.ignoreInterface = false;
        return packageScanner;
    }

    public PackageScanner addPackage(String pkg) {
        Package aPackage = Package.getPackage(pkg);
        this.addPackage(aPackage);
        return this;
    }

    public PackageScanner addPackage(Package pkg) {
        this.packages.add(pkg);
        return this;
    }

    public PackageScanner recursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public PackageScanner ignoreInterface(boolean ignore) {
        this.ignoreInterface = ignore;
        return this;
    }

    public PackageScanner orAnnotation(Class<? extends Annotation> annotation) {
        this.orAnnotations.add(annotation);
        return this;
    }

    public PackageScanner andAnnotation(Class<? extends Annotation> annotation) {
        this.andAnnotations.add(annotation);
        return this;
    }

    public PackageScanner andInterface(Class<?> interfc) {
        this.andImplementsInterface.add(interfc);
        return this;
    }

    public PackageScanner orInterface(Class<?> interfc) {
        this.orImplementsInterface.add(interfc);
        return this;
    }

    public PackageScanner orStartWithString(String startWithString) {
        if (StringUtils.isEmpty(startWithString)) {
            return this;
        }
        this.startWithStrings.add(startWithString);
        return this;
    }

    public PackageScanner orEndWithString(String endWithString) {
        if (StringUtils.isEmpty(endWithString)) {
            return this;
        }
        this.endWithStrings.add(endWithString);
        return this;
    }

    public Collection<Class<?>> scan() {
        Assert.notEmpty(this.packages, "\u5f85\u626b\u63cf\u7684\u5305\u4e3a\u7a7a\uff01");
        LinkedHashSet classes = new LinkedHashSet();
        ClassLookupHelper.ClassFileFilter classFileFilter = new ClassLookupHelper.ClassFileFilter(){

            @Override
            public boolean accept(String klassName, File file, ClassLoader loader) {
                return true;
            }

            @Override
            public boolean accept(String klassName, JarFile jar, JarEntry entry, ClassLoader loader) {
                return true;
            }
        };
        for (Package pkg : this.packages) {
            Set<Class<?>> scanClasses = ClassLookupHelper.getClasses(pkg, this.recursive, classFileFilter);
            for (Class<?> scanClass : scanClasses) {
                if (!this.isAnnotationPassed(scanClass) || !this.isStartWithPassed(scanClass) || !this.isInterfacePassed(scanClass)) continue;
                classes.add(scanClass);
            }
        }
        return classes;
    }

    private boolean isStartWithPassed(Class<?> clazz) {
        if (CollectionUtils.isEmpty(this.startWithStrings) && CollectionUtils.isEmpty(this.endWithStrings)) {
            return true;
        }
        for (String startWithString : this.startWithStrings) {
            if (!clazz.getSimpleName().startsWith(startWithString)) continue;
            return true;
        }
        for (String endWithString : this.endWithStrings) {
            if (!clazz.getSimpleName().endsWith(endWithString)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnnotationPassed(Class<?> clazz) {
        boolean annotationPresent;
        boolean flag = CollectionUtils.isEmpty(this.orAnnotations) && CollectionUtils.isEmpty(this.andAnnotations);
        for (Class<? extends Annotation> orAnnotation : this.orAnnotations) {
            annotationPresent = clazz.isAnnotationPresent(orAnnotation);
            if (!annotationPresent) continue;
            flag = true;
            break;
        }
        for (Class<? extends Annotation> andAnnotation : this.andAnnotations) {
            annotationPresent = clazz.isAnnotationPresent(andAnnotation);
            if (annotationPresent) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private boolean isInterfacePassed(Class<?> clazz) {
        boolean isImplementsInterface;
        boolean flag;
        boolean bl = flag = CollectionUtils.isEmpty(this.orImplementsInterface) && CollectionUtils.isEmpty(this.andImplementsInterface);
        if (this.ignoreInterface && clazz.isInterface()) {
            return false;
        }
        for (Class<?> orInterface : this.orImplementsInterface) {
            isImplementsInterface = orInterface.isAssignableFrom(clazz);
            if (!isImplementsInterface) continue;
            flag = true;
            break;
        }
        for (Class<?> andInterface : this.andImplementsInterface) {
            isImplementsInterface = andInterface.isAssignableFrom(clazz);
            if (!isImplementsInterface) {
                flag = false;
                break;
            }
            flag = true;
        }
        return flag;
    }

    public static void main(String[] args) {
        Collection<Class<?>> scan = PackageScanner.newScanner().addPackage(PackageScanner.class.getPackage()).orAnnotation(Deprecated.class).scan();
        System.out.println(scan);
        Collection<Class<?>> scan2 = PackageScanner.newScanner().addPackage(ArrayList.class.getPackage()).andInterface(Collection.class).scan();
        System.out.println(scan2);
    }
}

