/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.scan;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassLookupHelper {
    public static Collection<Class<?>> getClasses(ClassFileFilter filter) {
        LinkedHashSet<URLClassLoader> loaders = new LinkedHashSet<URLClassLoader>(8);
        loaders.addAll(ClassLookupHelper.getClassLoaders(Thread.currentThread().getContextClassLoader()));
        loaders.addAll(ClassLookupHelper.getClassLoaders(ClassLookupHelper.class.getClassLoader()));
        LinkedHashSet klasses = new LinkedHashSet();
        for (URLClassLoader cl : loaders) {
            for (URL url : cl.getURLs()) {
                String file = url.getFile();
                if (file.endsWith(".jar") || file.endsWith(".zip")) {
                    ClassLookupHelper.lookupClassesInJar(null, url, true, cl, filter, klasses);
                    continue;
                }
                ClassLookupHelper.lookupClassesInFileSystem(null, new File(file), true, cl, filter, klasses);
            }
        }
        return klasses;
    }

    private static Collection<URLClassLoader> getClassLoaders(ClassLoader baseClassLoader) {
        ArrayList<URLClassLoader> loaders = new ArrayList<URLClassLoader>(8);
        for (ClassLoader loader = baseClassLoader; loader != null && !"sun.misc.Launcher$ExtClassLoader".equals(loader.getClass().getName()); loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            loaders.add((URLClassLoader)loader);
        }
        return loaders;
    }

    public static Set<Class<?>> getClasses(Package pkg, boolean recursive, ClassFileFilter filter) {
        return ClassLookupHelper.getClasses(pkg.getName(), recursive, filter);
    }

    public static Set<Class<?>> getClasses(String packageName, boolean recursive, ClassFileFilter filter) {
        ArrayList<URL> urls;
        if (packageName == null || packageName.length() == 0) {
            throw new IllegalArgumentException("packageName is empty.");
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = loader.getResources(packageDirName);
            urls = Collections.list(dirs);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LinkedHashSet klasses = new LinkedHashSet();
        for (URL url : urls) {
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                ClassLookupHelper.lookupClassesInFileSystem(packageName, new File(url.getFile()), recursive, loader, filter, klasses);
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            ClassLookupHelper.lookupClassesInJar(packageName, url, recursive, loader, filter, klasses);
        }
        return klasses;
    }

    private static void lookupClassesInFileSystem(String packageName, File packagePath, final boolean recursive, ClassLoader loader, ClassFileFilter filter, Set<Class<?>> klasses) {
        if (!packagePath.exists() || !packagePath.isDirectory()) {
            return;
        }
        File[] dirfiles = packagePath.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        });
        String packageNamePrefix = "";
        if (packageName != null && packageName.length() > 0) {
            packageNamePrefix = packageName + '.';
        }
        for (File file : dirfiles) {
            if (file.isDirectory()) {
                ClassLookupHelper.lookupClassesInFileSystem(packageNamePrefix + file.getName(), file, recursive, loader, filter, klasses);
                continue;
            }
            String klassName = packageNamePrefix + file.getName().substring(0, file.getName().length() - 6);
            try {
                if (filter != null && !filter.accept(klassName, file, loader)) continue;
                Class<?> klass = loader.loadClass(klassName);
                klasses.add(klass);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lookupClassesInJar(String packageName, URL jarUrl, boolean recursive, ClassLoader loader, ClassFileFilter filter, Set<Class<?>> klasses) {
        String packageDirName = "";
        if (packageName != null && packageName.length() > 0) {
            packageDirName = packageName.replace('.', '/') + '/';
        }
        JarFile jar = null;
        try {
            jar = "jar".equals(jarUrl.getProtocol()) ? ((JarURLConnection)jarUrl.openConnection()).getJarFile() : new JarFile(jarUrl.getFile());
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (!name.startsWith(packageDirName) || !name.endsWith(".class") || name.lastIndexOf(47) > packageDirName.length() && !recursive) continue;
                String klassName = name.substring(0, name.length() - 6);
                klassName = klassName.replace('/', '.');
                try {
                    if (filter != null && !filter.accept(klassName, jar, entry, loader)) continue;
                    Class<?> klass = loader.loadClass(klassName);
                    klasses.add(klass);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (IOException iOException) {
        }
    }

    public static void main(String[] args) {
        Collection<Class<?>> classes = ClassLookupHelper.getClasses(new ClassFileFilter(){

            @Override
            public boolean accept(String klassName, File file, ClassLoader loader) {
                return true;
            }

            @Override
            public boolean accept(String klassName, JarFile jar, JarEntry entry, ClassLoader loader) {
                return true;
            }
        });
        for (Class<?> aClass : classes) {
            System.out.println(aClass);
        }
    }

    public static interface ClassFileFilter {
        public boolean accept(String var1, File var2, ClassLoader var3);

        public boolean accept(String var1, JarFile var2, JarEntry var3, ClassLoader var4);
    }
}

