/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.http;

import com.xunlei.channel.common.utils.http.HttpParameterHandler;
import com.xunlei.channel.common.utils.http.HttpUtils;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParameteredHttpUtils
extends HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(ParameteredHttpUtils.class);
    private static Map<Class<?>, HttpParameterHandler<?>> httpParameterHandlerMap = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(Object parameterEntity, String url, String charset, int timeout) throws UnsupportedEncodingException {
        if (parameterEntity == null) {
            return null;
        }
        Class<?> clazz = parameterEntity.getClass();
        HttpParameterHandler<?> httpParameterHandler = httpParameterHandlerMap.get(clazz);
        if (httpParameterHandler == null) {
            Class<?> clazz2 = clazz;
            synchronized (clazz2) {
                httpParameterHandler = new HttpParameterHandler(clazz);
                httpParameterHandlerMap.put(clazz, httpParameterHandler);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Use HttpParameterHandler to parse entity: {}", httpParameterHandler);
        }
        String response = ParameteredHttpUtils.doPost(httpParameterHandler, parameterEntity, url, charset, timeout);
        if (logger.isDebugEnabled()) {
            logger.debug("Got response: {} by url: {}, entity: {}", new Object[]{response, url, parameterEntity});
        }
        return response;
    }

    public static String doPost(Map<String, String> parameterMap, String url, String charset, int timeout) throws UnsupportedEncodingException {
        if (parameterMap == null) {
            return null;
        }
        List<NameValuePair> pairs = ParameteredHttpUtils.parseMapToPairs(parameterMap);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pairs, charset);
        String response = ParameteredHttpUtils.post(url, (HttpEntity)entity, charset, timeout);
        if (logger.isDebugEnabled()) {
            logger.debug("Got response: {} by url: {}, entity: {}", new Object[]{response, url, entity});
        }
        return response;
    }

    public static String doPost(HttpParameterHandler<?> handler, Object instance, String url, String charset, int timeout) throws UnsupportedEncodingException {
        Map<String, String> parameterMap = handler.getParameterMapWithObject(instance);
        if (logger.isDebugEnabled()) {
            logger.debug("Convert entity: {} to parameters: {}", instance, parameterMap);
        }
        List<NameValuePair> pairs = ParameteredHttpUtils.parseMapToPairs(parameterMap);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pairs, charset);
        return ParameteredHttpUtils.post(url, (HttpEntity)entity, charset, timeout);
    }

    public static <T> String doPostWithParameterHandler(HttpParameterHandler<T> handler, T instance, String url, String charset, int timeout) throws UnsupportedEncodingException {
        Map<String, String> parameterMap = handler.getParameterMap(instance);
        List<NameValuePair> pairs = ParameteredHttpUtils.parseMapToPairs(parameterMap);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pairs, charset);
        return ParameteredHttpUtils.post(url, (HttpEntity)entity, charset, timeout);
    }
}

