/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    public static final int DEFAULT_TIMEOUT = 6000;
    public static final String DEFAULT_CHARSET = "UTF-8";

    public static String getUrl(String domain, String path) {
        if (path == null) {
            return domain;
        }
        StringBuilder builder = new StringBuilder();
        if (!domain.contains("://")) {
            builder.append("http://");
        }
        builder.append(domain);
        if (!path.startsWith("/")) {
            builder.append("/");
        }
        builder.append(path);
        return builder.toString();
    }

    public static HttpClient getClient(int timeout) {
        if (timeout <= 0) {
            timeout = 6000;
        }
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder = requestBuilder.setSocketTimeout(timeout);
        requestBuilder.setConnectTimeout(timeout);
        requestBuilder.setConnectionRequestTimeout(timeout);
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(requestBuilder.build()).build();
        return client;
    }

    public static HttpClient getClient() {
        return HttpUtils.getClient(6000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeRequest(HttpRequestBase request, String charset, int timeout) {
        if (charset == null || "".equals(charset)) {
            charset = DEFAULT_CHARSET;
        }
        HttpResponse response = null;
        String result = null;
        try {
            HttpClient client = HttpUtils.getClient(timeout);
            if (client == null) {
                logger.error("Failed to get httpclient!");
                String string = null;
                return string;
            }
            response = client.execute((HttpUriRequest)request);
            if (response == null) {
                logger.error("response is null!");
                String string = null;
                return string;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                logger.error("statusCode: {}", (Object)statusCode);
                String string = null;
                return string;
            }
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)charset);
        }
        catch (Exception e) {
            logger.error("Http error with message: " + e.getMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            HttpUtils.releaseConnection(request);
        }
        return result;
    }

    public static String readResponse(HttpResponse response, String charset) throws IOException {
        if (response == null) {
            logger.error("response is null!");
            return null;
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            logger.error("statusCode: {}", (Object)statusCode);
            return null;
        }
        HttpEntity entity = response.getEntity();
        String result = EntityUtils.toString((HttpEntity)entity, (String)charset);
        return result;
    }

    private static void releaseConnection(HttpRequestBase request) {
        if (request != null) {
            request.releaseConnection();
        }
    }

    public static String post(String postUrl, HttpEntity reqEntity, String charset, int timeout) {
        HttpPost httpPost = new HttpPost(postUrl);
        httpPost.setEntity(reqEntity);
        String response = HttpUtils.executeRequest((HttpRequestBase)httpPost, charset, timeout);
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("Sent post to url: {} with request: {}", (Object)postUrl, (Object)EntityUtils.toString((HttpEntity)reqEntity, (String)charset));
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
        }
        return response;
    }

    public static String post(String postUrl, String content, String charset, int timeout) {
        StringEntity entity = new StringEntity(content, charset);
        entity.setContentType("application/x-www-form-urlencoded");
        return HttpUtils.post(postUrl, (HttpEntity)entity, charset, timeout);
    }

    public static String buildUrlParams(String url, Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return url;
        }
        StringBuilder builder = new StringBuilder(url);
        if (!url.contains("?")) {
            builder.append("?");
        } else {
            builder.append("&");
        }
        String httpParameters = HttpUtils.parseMapToHttpParameters(params);
        builder.append(httpParameters);
        String substring = builder.substring(0, builder.length());
        return substring;
    }

    public static String parseMapToHttpParameters(Map<String, String> parameters) {
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = parameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null || "".equals(key)) continue;
            builder.append(key);
            builder.append("=");
            builder.append(value);
            if (!iterator.hasNext()) continue;
            builder.append("&");
        }
        return builder.toString();
    }

    public static List<NameValuePair> parseMapToPairs(Map<String, String> parameters) {
        if (parameters == null) {
            return null;
        }
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>(parameters.size());
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            BasicNameValuePair pair = new BasicNameValuePair(key, value);
            pairs.add((NameValuePair)pair);
        }
        return pairs;
    }
}

