/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.http;

import com.xunlei.channel.common.utils.http.annotation.HttpParameter;
import com.xunlei.channel.common.utils.http.annotation.ParameterIgnore;
import com.xunlei.channel.common.utils.reflect.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpParameterHandler<T> {
    private static final Logger logger = LoggerFactory.getLogger(HttpParameterHandler.class);
    public Class<T> type;
    private Field[] declaredFields;
    private Map<Field, String> fieldParameterNameMap = new HashMap<Field, String>();

    public HttpParameterHandler(Class<T> type) {
        this.type = type;
        this.initFieldParameterNameMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFieldParameterNameMap() {
        HttpParameterHandler httpParameterHandler = this;
        synchronized (httpParameterHandler) {
            this.fieldParameterNameMap.clear();
            Map<Field, String> map = HttpParameterHandler.parseClass(this.type);
            this.fieldParameterNameMap.putAll(map);
            logger.info("Initialized field parameters: {} by class: {}", this.fieldParameterNameMap, this.type);
            this.declaredFields = ReflectionUtils.findFields(this.type, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inited() {
        if (this.fieldParameterNameMap == null) {
            HttpParameterHandler httpParameterHandler = this;
            synchronized (httpParameterHandler) {
                if (this.fieldParameterNameMap == null) {
                    return false;
                }
            }
        }
        return true;
    }

    private void check() {
        if (!this.inited()) {
            this.initFieldParameterNameMap();
        }
    }

    public Map<String, String> getParameterMap(T instance) {
        if (instance == null) {
            return null;
        }
        this.check();
        return this.parseParameters(instance);
    }

    public Map<String, String> getParameterMapWithObject(Object instance) {
        if (instance == null) {
            return null;
        }
        if (!instance.getClass().equals(this.type)) {
            return null;
        }
        Object i = instance;
        return this.getParameterMap(i);
    }

    private Map<String, String> parseParameters(T instance) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Field declaredField : this.declaredFields) {
            if (Modifier.isStatic(declaredField.getModifiers()) || Modifier.isNative(declaredField.getModifiers())) continue;
            String name = this.fieldParameterNameMap.get(declaredField);
            if (name == null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Could'nt found parameter name on field: {}", (Object)declaredField);
                continue;
            }
            Object fieldValue = null;
            try {
                fieldValue = ReflectionUtils.getFieldValue(declaredField, instance);
            }
            catch (IllegalAccessException e) {
                logger.error("", (Throwable)e);
            }
            if (fieldValue == null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Null value of field: {}", (Object)declaredField);
                continue;
            }
            String value = fieldValue.toString();
            map.put(name, value);
        }
        return map;
    }

    private static Map<Field, String> parseClass(Class<?> clazz) {
        Field[] fields;
        HashMap<Field, String> map = new HashMap<Field, String>();
        for (Field field : fields = ReflectionUtils.findFields(clazz, true)) {
            String parameterName;
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isNative(field.getModifiers()) || (parameterName = HttpParameterHandler.getFieldParameterName(field)) == null || "".equals(parameterName)) continue;
            map.put(field, parameterName);
        }
        return map;
    }

    public static String getFieldParameterName(Field field) {
        if (field.getAnnotation(ParameterIgnore.class) != null) {
            return null;
        }
        String methodName = null;
        if (!field.isAnnotationPresent(HttpParameter.class)) {
            methodName = HttpParameterHandler.parseMethod(field);
        }
        if (methodName == null || "".equals(methodName)) {
            methodName = HttpParameterHandler.parseField(field);
        }
        return methodName;
    }

    public static String parseField(Field field) {
        String value;
        HttpParameter annotation = field.getAnnotation(HttpParameter.class);
        if (annotation == null || "".equals(value = annotation.value())) {
            return field.getName();
        }
        return value;
    }

    public static String parseMethod(Field field) {
        try {
            Method getMethod = ReflectionUtils.findGetMethod(field);
            if (!getMethod.isAnnotationPresent(HttpParameter.class)) {
                return null;
            }
            HttpParameter annotation = getMethod.getAnnotation(HttpParameter.class);
            if (annotation == null) {
                return null;
            }
            return annotation.value();
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
    }
}

