package com.xunlei.channel.common.utils.sql;

import com.xunlei.channel.common.utils.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;

/**
 * @author xiongyingqi
 * @since 20171012//
 */
public abstract class SqlUtils {
    private static final Logger logger = LoggerFactory.getLogger(SqlUtils.class);

    /**
     * Convert args array to mysql in statements.<p></p>
     * For example:<br>
     *  args={1,2,3,4} <br>
     * Results: <br>
     *  ('1','2','3','4')
     * @param args in args
     * @return Statements of in.
     */
    public static String buildArgsToInStatements(String[] args) {
        Assert.notEmpty(args);
        String delimiter = "";
        StringBuilder builder = new StringBuilder("(");
        for (String arg : args) {
            builder
                    .append(delimiter)
                    .append("'")
                    .append(arg)
                    .append("'")
                    ;
            delimiter = ",";
        }
        builder.append(")");
        String statementIn = builder.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("Build args: {} to sql statements: {}", Arrays.toString(args), statementIn);
        }
        return statementIn;
    }

}
