package com.xunlei.channel.common.utils.object;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/**
 * 提供对象与map map与对象 等基础转换
 * 
 * @author huangchunhui 2014年5月12日 下午2:52:13
 */
public class ObjectUtil {

    /**
     * 从对象中获取Map
     * <p>
     * 跳过key为null或者""的属性,值为null或者""的属性会被包含
     * 
     * @param obj 对象的成员变量必须都为基本数据类型或者String
     * @return
     */
    @SuppressWarnings("rawtypes")
    public static Map<String, Object> getMapFromObject(Object obj) throws Exception {
        Map<String, Object> map = new HashMap<String, Object>();
        if (null == obj) {
            throw new Exception("obj is empty!");
        }
        Class clazz = obj.getClass();
        Field fields[] = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; i++) {
            Field field = fields[i];
            field.setAccessible(true);

            String key = field.getName();
            if (null == key || "".equals(key)) {
                continue;
            }

            Object value = field.get(obj);
            map.put(key, value);
        }
        return map;
    }

    /**
     * 从对象中获取Map
     * <p>
     * 跳过key为null或者""的属性,跳过value为null或者""的属性
     * 
     * @param obj 对象的成员变量必须都为基本数据类型或者String
     * @return
     */
    @SuppressWarnings("rawtypes")
    public static Map<String, Object> getMapFromObjectTrim(Object obj) throws Exception {
        Map<String, Object> map = new HashMap<String, Object>();
        if (null == obj) {
            throw new Exception("obj is empty!");
        }
        Class clazz = obj.getClass();
        Field fields[] = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; i++) {
            Field field = fields[i];
            field.setAccessible(true);

            String key = field.getName();
            if (null == key || "".equals(key)) {
                continue;
            }

            Object value = field.get(obj);
            if (null == value || "".equals(value)) {
                continue;
            }

            map.put(key, value);
        }
        return map;
    }

    /**
     * 把一般Map转换成sortedMap
     * 
     * @param map
     * @return
     */
    public static SortedMap<String, Object> mapToSortedMap(Map<String, Object> map) {
        SortedMap<String, Object> resMap = new TreeMap<String, Object>();
        if (map instanceof SortedMap) {
            return resMap = (SortedMap<String, Object>) map;
        }
        Iterator<String> it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            Object value = map.get(key);
            resMap.put(key, value);
        }
        return resMap;
    }

    /**
     * 从Map中获取对象
     * 
     * @param map
     * @param clazz
     * @return 返回值不会为null
     * @throws Exception 调用需处理异常
     */
    @SuppressWarnings("rawtypes")
    public static Object getObjectFromMap(Map<String, Object> map, Class clazz) throws Exception {
        if (null == map || map.size() == 0) {
            throw new Exception("map is empty!");
        }
        Object obj = clazz.newInstance();
        if (null == obj) {
            throw new Exception("Class:" + clazz.getName() + ",can not create new instance!");
        }
        Field fields[] = clazz.getDeclaredFields();
        Iterator<String> it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            Object value = map.get(key);
            if (null == value) {
                continue;
            }
            for (int i = 0; i < fields.length; i++) {
                Field field = fields[i];
                field.setAccessible(true);
                String fieldName = field.getName();
                if (fieldName.equals(key)) {
                    field.set(obj, value);
                }
            }
        }
        return obj;
    }
}
