package com.xunlei.channel.sms.util.context;

import java.util.HashMap;
import java.util.Map;

/**
 * @author xiongyingqi
 * @since 17-5-11 下午8:42
 */
class Context<T> {
    private volatile Class<T> clazz;
    private static Map<Class<?>, ThreadLocal<?>> classThreadLocalMap = new HashMap<Class<?>, ThreadLocal<?>>();

    public Context(Class<T> clazz) {
        this.clazz = clazz;
    }

    @SuppressWarnings("unchecked")
    protected T getContext() {
        ThreadLocal<?> threadLocal = classThreadLocalMap.get(clazz);
        if (threadLocal == null) {
            return null;
        }
        return (T) threadLocal.get();
    }

    @SuppressWarnings("unchecked")
    protected void setContext(final T instance) {
        ThreadLocal<T> threadLocal = (ThreadLocal<T>) classThreadLocalMap.get(clazz);
        if (threadLocal == null) {
            synchronized (clazz) {
                threadLocal = new ThreadLocal<T>() {
                    @Override
                    protected T initialValue() {
                        return instance;
                    }
                };
                classThreadLocalMap.put(clazz, threadLocal);
            }
        }
        threadLocal.set(instance);
    }
}
