/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.object;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ObjectUtil {
    public static Map<String, Object> getMapFromObject(Object obj) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null == obj) {
            throw new Exception("obj is empty!");
        }
        Class<?> clazz = obj.getClass();
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            field.setAccessible(true);
            String key = field.getName();
            if (null == key || "".equals(key)) continue;
            Object value = field.get(obj);
            map.put(key, value);
        }
        return map;
    }

    public static Map<String, Object> getMapFromObjectTrim(Object obj) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null == obj) {
            throw new Exception("obj is empty!");
        }
        Class<?> clazz = obj.getClass();
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Object value;
            Field field = fields[i];
            field.setAccessible(true);
            String key = field.getName();
            if (null == key || "".equals(key) || null == (value = field.get(obj)) || "".equals(value)) continue;
            map.put(key, value);
        }
        return map;
    }

    public static SortedMap<String, Object> mapToSortedMap(Map<String, Object> map) {
        TreeMap<String, Object> resMap = new TreeMap();
        if (map instanceof SortedMap) {
            resMap = (SortedMap)map;
            return resMap;
        }
        for (String key : map.keySet()) {
            Object value = map.get(key);
            resMap.put(key, value);
        }
        return resMap;
    }

    public static Object getObjectFromMap(Map<String, Object> map, Class clazz) throws Exception {
        if (null == map || map.size() == 0) {
            throw new Exception("map is empty!");
        }
        Object obj = clazz.newInstance();
        if (null == obj) {
            throw new Exception("Class:" + clazz.getName() + ",can not create new instance!");
        }
        Field[] fields = clazz.getDeclaredFields();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (null == value) continue;
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                field.setAccessible(true);
                String fieldName = field.getName();
                if (!fieldName.equals(key)) continue;
                field.set(obj, value);
            }
        }
        return obj;
    }
}

