/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.sql;

import com.xunlei.channel.common.utils.Assert;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SqlUtils {
    private static final Logger logger = LoggerFactory.getLogger(SqlUtils.class);

    public static String buildArgsToInStatements(String[] args) {
        Assert.notEmpty(args);
        String delimiter = "";
        StringBuilder builder = new StringBuilder("(");
        for (String arg : args) {
            builder.append(delimiter).append("'").append(arg).append("'");
            delimiter = ",";
        }
        builder.append(")");
        String statementIn = builder.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("Build args: {} to sql statements: {}", (Object)Arrays.toString(args), (Object)statementIn);
        }
        return statementIn;
    }
}

