/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public abstract class JacksonHelper {
    private static final ObjectMapper mapper = JacksonHelper.newMapper();

    public static String getJsonString(Object o) {
        ObjectMapper mapper = JacksonHelper.newMapper();
        try {
            return mapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T> T convertJsonByClass(String json, Class<T> clazz) throws IOException {
        ObjectMapper mapper = JacksonHelper.newMapper();
        return (T)mapper.readValue(json, clazz);
    }

    public static ObjectMapper newConfiguredMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        return objectMapper;
    }

    public static ObjectMapper newMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        return objectMapper;
    }
}

