/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.concurrent;

import java.util.concurrent.locks.ReentrantLock;

public class LockSupport {
    private ReentrantLock[] reentrantLock;
    private int lockSize;

    private LockSupport(int lockSize) {
        this.lockSize = lockSize;
        this.reentrantLock = new ReentrantLock[lockSize];
        for (int i = 0; i < lockSize; ++i) {
            this.reentrantLock[i] = new ReentrantLock();
        }
    }

    public static LockSupport newInstance(int lockSize) {
        return new LockSupport(lockSize);
    }

    public ReentrantLock getLock(Object object) {
        if (object == null) {
            throw new NullPointerException("Lock object is null!");
        }
        int hash = LockSupport.hash(object);
        ReentrantLock reentrantLock = this.lockForHash(hash);
        return reentrantLock;
    }

    private ReentrantLock lockForHash(int hash) {
        int index = (hash &= Integer.MAX_VALUE) % this.lockSize;
        return this.reentrantLock[index];
    }

    private static int hash(Object object) {
        int h = object.hashCode();
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }
}

