/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.date;

import com.xunlei.channel.common.utils.Assert;
import com.xunlei.channel.common.utils.string.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public abstract class DateUtils {
    public static final String SP1 = "yyyy-MM-dd HH:mm:ss";
    public static final String SP2 = "yyyyMMddHHmmss";
    public static final String SP3 = "yyyy-MM-dd";
    public static final String SP4 = "yyyyMMdd";

    public static String getNowDate() {
        SimpleDateFormat simpleDateFormat = DateUtils.getDateFormat(SP3);
        return simpleDateFormat.format(new Date());
    }

    public static String getNowDateTime() {
        SimpleDateFormat simpleDateFormat = DateUtils.getDateFormat(SP1);
        return simpleDateFormat.format(new Date());
    }

    public static SimpleDateFormat getDateFormat(String format) {
        Assert.hasText(format);
        return new SimpleDateFormat(format);
    }

    public static long getUnixTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String parseTime(String time, String formatStrBefore, String formatStrAfter) throws ParseException {
        SimpleDateFormat bfSp = new SimpleDateFormat(formatStrBefore);
        SimpleDateFormat afSp = new SimpleDateFormat(formatStrAfter);
        return afSp.format(bfSp.parse(time));
    }

    public static int compareTime(String time1, String time2, String formatStr) throws ParseException {
        Date date2;
        SimpleDateFormat sp = new SimpleDateFormat(formatStr);
        Date date1 = sp.parse(time1);
        if (date1.before(date2 = sp.parse(time2))) {
            return 1;
        }
        if (date1.after(date2)) {
            return -1;
        }
        return 0;
    }

    public static String getCurrentTime(String formatStr) {
        SimpleDateFormat sp = new SimpleDateFormat(formatStr);
        return sp.format(new Date());
    }

    public static String getTimeAfter(int field, int amount, String formatStr) {
        Calendar cal = Calendar.getInstance();
        cal.add(field, amount);
        SimpleDateFormat sp = new SimpleDateFormat(formatStr);
        return sp.format(cal.getTime());
    }

    public static String getFirstDayOfMonth(String formatStr) {
        SimpleDateFormat sp = new SimpleDateFormat(formatStr);
        Calendar date = Calendar.getInstance();
        date.set(5, 1);
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        return sp.format(date.getTime());
    }

    @Deprecated
    public static String calculateTime(String time, String addpart, int num) throws ParseException {
        SimpleDateFormat yyyyMMddHHmmssDateFormat = new SimpleDateFormat(SP1);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(yyyyMMddHHmmssDateFormat.parse(time));
        if (addpart.equalsIgnoreCase("Y")) {
            cal.add(1, num);
        } else if (addpart.equalsIgnoreCase("M")) {
            cal.add(2, num);
        } else if (addpart.equalsIgnoreCase("D")) {
            cal.add(5, num);
        } else if (addpart.equalsIgnoreCase("H")) {
            cal.add(10, num);
        } else if (addpart.equalsIgnoreCase("F")) {
            cal.add(12, num);
        } else if (addpart.equalsIgnoreCase("S")) {
            cal.add(13, num);
        }
        return yyyyMMddHHmmssDateFormat.format(cal.getTime());
    }

    public static String calculateTime(String time, String formatStr, String addpart, int num) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatStr);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(dateFormat.parse(time));
        if (addpart.equalsIgnoreCase("Y")) {
            cal.add(1, num);
        } else if (addpart.equalsIgnoreCase("M")) {
            cal.add(2, num);
        } else if (addpart.equalsIgnoreCase("D")) {
            cal.add(5, num);
        } else if (addpart.equalsIgnoreCase("H")) {
            cal.add(10, num);
        } else if (addpart.equalsIgnoreCase("F")) {
            cal.add(12, num);
        } else if (addpart.equalsIgnoreCase("S")) {
            cal.add(13, num);
        }
        return dateFormat.format(cal.getTime());
    }

    public static long dateDiffer(String time1, String time2, String formatStr) throws ParseException {
        SimpleDateFormat sp = new SimpleDateFormat(formatStr);
        Date date1 = sp.parse(time1);
        Date date2 = sp.parse(time2);
        long differ = Math.abs(date1.getTime() - date2.getTime());
        return differ;
    }

    public static String getDayString(String formatString, int days) {
        SimpleDateFormat sp = new SimpleDateFormat(formatString);
        return sp.format(DateUtils.getDays(days));
    }

    public static Date getDays(int days) {
        Calendar date = Calendar.getInstance();
        date.add(5, days);
        return date.getTime();
    }

    public static Date getDateAfterDays(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static String getFirstDateStrOfMonth() {
        SimpleDateFormat format = new SimpleDateFormat(SP3);
        return format.format(DateUtils.getFirstDateOfMonth());
    }

    public static Date getFirstDateOfMonth() {
        Calendar date = Calendar.getInstance();
        date.set(5, 1);
        return DateUtils.getZeroTime(date.getTime());
    }

    public static Date getZeroTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastTime(Date date) {
        Date zeroTime = DateUtils.getZeroTime(date);
        Date dateAfterDays = DateUtils.getDateAfterDays(zeroTime, 1);
        long l = dateAfterDays.getTime() - 1L;
        return new Date(l);
    }

    public static Date parseDateByFormat(String date, String format) throws ParseException {
        SimpleDateFormat dateFormat = DateUtils.getDateFormat(format);
        return dateFormat.parse(date);
    }

    public static String getYear(String date) {
        Assert.isTrue(StringUtils.hasText(date) && date.length() >= 4, "\u89e3\u6790\u65e5\u671f\u5931\u8d25\uff01\u65e5\u671f\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e3\uff01");
        return date.substring(0, 4);
    }

    public static int getSeason(String date) {
        Assert.isTrue(StringUtils.hasText(date) && date.length() >= 7, "\u89e3\u6790\u5b63\u5ea6\u5931\u8d25\uff01\u65e5\u671f\u683c\u5f0f\u5fc5\u987b\u662f\uff1ayyyy-MM*");
        String monthStr = date.substring(5, 7);
        Integer month = Integer.parseInt(monthStr);
        Assert.isTrue(month != null && month >= 1, "\u89e3\u6790\u5b63\u5ea6\u5931\u8d25\uff01\u65e5\u671f\u683c\u5f0f\u5fc5\u987b\u662f\uff1ayyyy-MM*");
        return month / 3 + (month % 3 > 0 ? 1 : 0);
    }
}

