package com.xunlei.channel.common.utils.pattern;

import com.xunlei.channel.common.utils.string.StringUtils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author xiongyingqi
 * @since 16-12-20 下午9:07
 */
public abstract class PatternUtils {
    public static final Pattern HOST_PORT_PATTERN = Pattern.compile("(\\w+\\.)*\\w+:\\d+");
    public static final Pattern HOST_PATTERN = Pattern.compile("(\\w+\\.)*\\w+");
    public static final Pattern HTTPS_HOST_PATTERN = Pattern.compile("https://(\\w+\\.)*\\w+");
    public static final Pattern HTTPS_HOST_PORT_PATTERN = Pattern.compile("https://(\\w+\\.)*\\w+:\\d+");
    public static final Pattern HTTP_HOST_PORT_PATTERN = Pattern.compile("http://(\\w+\\.)*\\w+:\\d+");
    public static final Pattern HTTP_HOST_PATTERN = Pattern.compile("http://(\\w+\\.)*\\w+");

    public static String[] getHostAndPort(String url) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }
        Matcher hostPortMatcher = HOST_PORT_PATTERN.matcher(url);
        Matcher hostMatcher = HOST_PATTERN.matcher(url);
        if (hostPortMatcher.matches()) {
            return url.split(":");
        } else if (hostMatcher.matches()) {
            return new String[]{url, "80"};
        }

        Matcher httpHostPortPattern = HTTP_HOST_PORT_PATTERN.matcher(url);
        if (httpHostPortPattern.find()) {
            String group = httpHostPortPattern.group();
            String removedHttp = group.substring(7);
            return getHostAndPort(removedHttp);
        }

        Matcher httpHostPattern = HTTP_HOST_PATTERN.matcher(url);
        if (httpHostPattern.find()) {
            String group = httpHostPattern.group();
            String removedHttp = group.substring(7);
            return getHostAndPort(removedHttp);
        }

        Matcher httpsHostPortMatcher = HTTPS_HOST_PORT_PATTERN.matcher(url);
        if (httpsHostPortMatcher.find()) {
            String group = httpsHostPortMatcher.group();
            String removedHttp = group.substring(8);
            return getHostAndPort(removedHttp);
        }

        Matcher httpsHostMatcher = HTTPS_HOST_PATTERN.matcher(url);
        if (httpsHostMatcher.find()) {
            String group = httpsHostMatcher.group();
            String removedHttp = group.substring(8);
            return getHostAndPort(removedHttp + ":443");
        }


        hostPortMatcher.reset();
        hostMatcher.reset();
        if (hostPortMatcher.find()) {
            String group = hostPortMatcher.group();
            return getHostAndPort(group);
        } else if (hostMatcher.find()) {
            String group = hostMatcher.group();
            return getHostAndPort(group);
        } else {
            return null;
        }
    }

    public static void main(String[] args) {
        String url = "192.168.1.1:8080/shitPaths";
        Matcher matcher = HOST_PORT_PATTERN.matcher(url);
        if (matcher.find()) {
            String group = matcher.group();
            System.out.println(group);
        }
    }
}
