/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.reflect;

import com.xunlei.channel.common.utils.reflect.ReflectionUtils;
import com.xunlei.channel.common.utils.string.StringUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpReflectionUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpReflectionUtils.class);
    public static final String PAIRS_DELIMITER = "&";
    public static final String KV_DELIMITER = "=";

    public static Map<String, String> parseHttpResponseToMap(String response) {
        String[] pairs;
        if (StringUtils.isEmpty(response)) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (String pair : pairs = StringUtils.delimitedListToStringArray(response, PAIRS_DELIMITER)) {
            int i = pair.indexOf(KV_DELIMITER);
            if (i < 0) {
                logger.warn("Pair: {} is illegal!", (Object)pair);
                continue;
            }
            String key = pair.substring(0, i);
            String value = pair.substring(i + 1, pair.length());
            if (logger.isDebugEnabled()) {
                logger.debug("Parse pair to key: {} value: {}", (Object)key, (Object)value);
            }
            params.put(key, value);
        }
        return params;
    }

    public static <T> T parseHttpResponseToInstance(String response, Class<T> tClass) throws IllegalAccessException, InstantiationException {
        if (StringUtils.isEmpty(response)) {
            return null;
        }
        Map<String, String> params = HttpReflectionUtils.parseHttpResponseToMap(response);
        T t = tClass.newInstance();
        Field[] fields = ReflectionUtils.findFields(tClass, true);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            try {
                ReflectionUtils.setFieldValueToInstance(key, value, t, fields);
            }
            catch (IllegalAccessException e) {
                logger.error("Error when set param: " + key + " value: " + value + " to: " + tClass + ". Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return t;
    }
}

