/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.sign;

import com.xunlei.channel.common.utils.Assert;
import com.xunlei.channel.common.utils.CollectionUtils;
import com.xunlei.channel.common.utils.sign.DigestUtils;
import com.xunlei.channel.common.utils.string.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignUtils {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final Logger logger = LoggerFactory.getLogger(SignUtils.class);

    public static boolean checkSign(String signed, Map<String, String> params, Set<String> unsignedKeys, String append) {
        return SignUtils.checkSign(signed, params, unsignedKeys, append, DEFAULT_CHARSET);
    }

    public static boolean checkSign(String signed, Map<String, String> params, Set<String> unsignedKeys, String append, String charset) {
        return SignUtils.checkSign(signed, params, unsignedKeys, append, charset, true);
    }

    public static boolean checkSign(String signed, Map<String, String> params, Set<String> unsignedKeys, String append, String charset, boolean ignoreEmptyValue) {
        if (signed == null) {
            return false;
        }
        String sign = SignUtils.sign(params, unsignedKeys, append, charset, ignoreEmptyValue);
        boolean match = sign.equalsIgnoreCase(signed);
        if (!match) {
            logger.info("Mismatch sign! signed: {} ours: {}", (Object)signed, (Object)sign);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Check sign succeed! signed: {} ours: {}", (Object)signed, (Object)sign);
        }
        return match;
    }

    public static String sign(Map<String, String> params, Set<String> unsignedKeys, String append, String charset, boolean ignoreEmptyValue) {
        Assert.notEmpty(params, "parameters is null!");
        SortedMap<String, String> sortedMap = SignUtils.convertToSignMap(params, unsignedKeys, ignoreEmptyValue);
        String signString = SignUtils.toSignString(sortedMap);
        if (StringUtils.hasText(append)) {
            signString = signString + append;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Final sign string: {}", (Object)signString);
        }
        return SignUtils.md5(signString, charset);
    }

    public static SortedMap<String, String> convertToSignMap(Map<String, String> params, Set<String> unsignedKeys, boolean ignoreEmptyValue) {
        Assert.notEmpty(params, "parameters is null!");
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        sortedMap.putAll(params);
        if (ignoreEmptyValue) {
            Iterator iterator = sortedMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (StringUtils.hasText((String)entry.getValue())) continue;
                iterator.remove();
            }
        }
        if (CollectionUtils.isEmpty(unsignedKeys)) {
            return sortedMap;
        }
        for (String unsignedKey : unsignedKeys) {
            String removed = (String)sortedMap.remove(unsignedKey);
            logger.debug("Removed unsigned key: '{}' with value: {}", (Object)unsignedKey, (Object)removed);
        }
        return sortedMap;
    }

    public static String toSignString(SortedMap<String, String> params) {
        Assert.notEmpty(params, "parameters is null!");
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (!StringUtils.hasText(entry.getKey())) continue;
            builder.append(entry.getKey()).append("=").append(entry.getValue());
            if (!iterator.hasNext()) continue;
            builder.append("&");
        }
        String signMessage = builder.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("Returning sign string: \"{}\" by params: {}", (Object)signMessage, params);
        }
        return signMessage;
    }

    public static String md5(String signString, String charset) {
        Assert.hasText(signString, "Origin sign is null!");
        try {
            byte[] bytes = signString.getBytes(charset);
            String md5 = DigestUtils.md5DigestAsHex(bytes).toUpperCase();
            if (logger.isDebugEnabled()) {
                logger.debug("Returning md5: {} by sign string: {}", (Object)md5, (Object)signString);
            }
            return md5;
        }
        catch (UnsupportedEncodingException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }
}

