/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.common.utils.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReflectionUtils {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionUtils.class);

    public static <T> void setFieldValueToInstance(String name, String value, T instance, Field[] inFields) throws IllegalAccessException {
        Field field = null;
        for (Field inField : inFields) {
            if (!inField.getName().equals(name)) continue;
            field = inField;
        }
        if (field == null) {
            return;
        }
        field.setAccessible(true);
        field.set(instance, value);
    }

    public static Map<String, String> convertObjectFieldsToMap(Object o) {
        if (o == null) {
            return null;
        }
        return ReflectionUtils.convertObjectFieldsToMap(o, o.getClass());
    }

    public static Map<String, String> convertObjectFieldsToMap(Object o, Class clazz) {
        return ReflectionUtils.convertObjectFieldsToMap(o, clazz, true);
    }

    public static Map<String, String> convertObjectFieldsToMap(Object o, Class clazz, boolean recursion) {
        Field[] fields;
        if (o == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Field field : fields = ReflectionUtils.findFields(clazz, recursion)) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                Object fieldValue = field.get(o);
                String name = field.getName();
                String fieldValueString = null;
                if (fieldValue != null) {
                    fieldValueString = fieldValue.toString();
                }
                map.put(name, fieldValueString);
            }
            catch (IllegalAccessException e) {
                logger.error("", (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Convert object: {} to map: {}", o, map);
        }
        return map;
    }

    public static List<String> findFieldNames(Class clazz, boolean recursion) {
        Field[] fields = ReflectionUtils.findFields(clazz, recursion);
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : fields) {
            fieldNames.add(field.getName());
        }
        return fieldNames;
    }

    public static Field[] findFields(Class clazz, boolean recursion) {
        Field[] clazzDeclaredFields;
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : clazzDeclaredFields = clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            fields.add(field);
        }
        if (recursion) {
            for (Class superclass = clazz.getSuperclass(); superclass != Object.class; superclass = superclass.getSuperclass()) {
                Field[] superFields = ReflectionUtils.findFields(superclass, false);
                fields.addAll(Arrays.asList(superFields));
            }
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static Method findGetMethod(Field field) throws NoSuchMethodException {
        if (field == null) {
            return null;
        }
        Class<?> declaringClass = field.getDeclaringClass();
        String name = field.getName();
        String suffix = name.substring(0, 1).toUpperCase();
        if (name.length() > 1) {
            suffix = suffix + name.substring(1);
        }
        String methodName = "get" + suffix;
        try {
            return declaringClass.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (field.getType() == Boolean.TYPE) {
                if (name.startsWith("is")) {
                    return declaringClass.getDeclaredMethod(name, new Class[0]);
                }
                methodName = "is" + suffix;
                return declaringClass.getDeclaredMethod(methodName, new Class[0]);
            }
            throw e;
        }
    }

    public static Object getFieldValue(Field field, Object instance) throws IllegalAccessException {
        field.setAccessible(true);
        return field.get(instance);
    }
}

