/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.threadpool.impl;

import com.xunlei.channel.sms.threadpool.CallableThread;
import com.xunlei.channel.sms.threadpool.CallableThreadFactory;
import com.xunlei.channel.sms.threadpool.ThreadCallbackHandler;
import com.xunlei.channel.sms.threadpool.ThreadPoolContainer;
import com.xunlei.channel.sms.threadpool.ThreadPoolScheduler;
import com.xunlei.channel.sms.threadpool.ThreadPoolStatus;
import com.xunlei.channel.sms.threadpool.impl.ThreadPoolContainerImpl;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolSchedulerImpl<T>
implements ThreadPoolScheduler {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolSchedulerImpl.class);
    private CallableThread<T> callableThread;
    private CallableThreadFactory<T> callableThreadFactory;
    private ThreadPoolContainer threadPoolContainer;
    private boolean useFactory;
    private ThreadPoolStatus status;
    private AtomicBoolean changingStatus = new AtomicBoolean(false);

    public ThreadPoolSchedulerImpl(CallableThreadFactory<T> callableThreadFactory, ThreadCallbackHandler callbackHandler, int corePoolSize, int maxPoolSize, String threadNamePrefix) {
        this.useFactory = true;
        this.callableThreadFactory = callableThreadFactory;
        callbackHandler.setThreadPoolScheduler(this);
        this.threadPoolContainer = new ThreadPoolContainerImpl(corePoolSize, maxPoolSize, threadNamePrefix);
    }

    public ThreadPoolSchedulerImpl(CallableThread<T> callableThread, ThreadCallbackHandler callbackHandler, int corePoolSize, int maxPoolSize, String threadNamePrefix) {
        this.useFactory = false;
        this.callableThread = callableThread;
        callbackHandler.setThreadPoolScheduler(this);
        this.threadPoolContainer = new ThreadPoolContainerImpl(corePoolSize, maxPoolSize, threadNamePrefix);
    }

    @Override
    public void resetPoolSize(int newSize) {
        while (!this.changingStatus.compareAndSet(false, true)) {
        }
        this.status = ThreadPoolStatus.STOPPING;
        this.threadPoolContainer.resetPoolSize(newSize);
        this.start();
        this.status = ThreadPoolStatus.RUNNING;
        this.changingStatus.compareAndSet(true, false);
    }

    @Override
    public void submit() {
        while (this.changingStatus.get()) {
        }
        if (ThreadPoolStatus.STOPPING.equals((Object)this.status) || ThreadPoolStatus.STOPPED.equals((Object)this.status)) {
            logger.warn("Thread pool's status is: {}, so stop to submit new jobs!", (Object)this.status);
            return;
        }
        ThreadPoolExecutor threadPool = this.threadPoolContainer.getThreadPool();
        if (this.useFactory) {
            CallableThread<T> callableThread = this.callableThreadFactory.produceCallableThread();
            threadPool.submit(callableThread);
        } else {
            threadPool.submit(this.callableThread);
        }
    }

    @Override
    public void setThreadPoolContainer(ThreadPoolContainer threadPoolContainer) {
        if (threadPoolContainer == null) {
            logger.error("ThreadPoolContainer is null when setting a new one! so dismiss!");
            return;
        }
        this.threadPoolContainer = threadPoolContainer;
    }

    @Override
    public ThreadPoolContainer getThreadPoolContainer() {
        return this.threadPoolContainer;
    }

    @Override
    public void start() {
        logger.info("Thread pool scheduler started!");
        while (!this.changingStatus.compareAndSet(false, true)) {
        }
        ThreadPoolExecutor executorService = this.threadPoolContainer.getThreadPool();
        this.changingStatus.compareAndSet(true, false);
        int maximumPoolSize = executorService.getMaximumPoolSize();
        for (int i = 0; i < maximumPoolSize; ++i) {
            this.submit();
        }
        this.status = ThreadPoolStatus.RUNNING;
    }

    @Override
    public void stop() {
        this.status = ThreadPoolStatus.STOPPING;
        this.threadPoolContainer.stop();
    }

    @Override
    public ThreadPoolStatus status() {
        return this.status;
    }
}

