/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.threadpool.impl;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.xunlei.channel.sms.threadpool.ThreadPoolContainer;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ThreadPoolContainerImpl
implements ThreadPoolContainer {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolContainer.class);
    private ThreadPoolExecutor executorService;
    private volatile boolean shutdown = false;

    public ThreadPoolContainerImpl(int corePoolSize, int maxPoolSize, String threadNamePrefix) {
        Assert.isTrue((corePoolSize >= 1 ? 1 : 0) != 0, (String)"CorePoolSize must at least 1!");
        Assert.isTrue((maxPoolSize >= 1 ? 1 : 0) != 0, (String)"MaxPoolSize must at least 1!");
        if (Strings.isNullOrEmpty((String)threadNamePrefix)) {
            threadNamePrefix = "sms-gateway-pool-";
        }
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadNamePrefix + "%d").build();
        this.executorService = new ThreadPoolExecutor(corePoolSize, maxPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue(), threadFactory){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                ThreadPoolContainerImpl.printException(r, t);
            }
        };
    }

    private static void printException(Runnable r, Throwable t) {
        if (t == null && r instanceof Future) {
            try {
                Future future = (Future)((Object)r);
                if (future.isDone()) {
                    future.get();
                }
            }
            catch (CancellationException ce) {
                t = ce;
            }
            catch (ExecutionException ee) {
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (t != null) {
            logger.error(t.getMessage(), t);
        }
    }

    private void shutdown() {
        if (this.shutdown) {
            logger.error("Thread pool is shutting down!");
            return;
        }
        this.shutdown = true;
        List<Runnable> runnables = this.executorService.shutdownNow();
        logger.warn("Shutting down thread pool! least thread size: {} and should be invoke continue!", (Object)runnables.size());
        for (Runnable runnable : runnables) {
            Thread thread = new Thread(runnable);
            thread.start();
        }
    }

    public void setThreadPool(ThreadPoolExecutor executorService) {
        if (executorService == null) {
            logger.error("ThreadPoolExecutor is null when setting a new one! so dismiss!");
            return;
        }
        this.executorService = executorService;
    }

    @Override
    public void stop() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetPoolSize(int newPoolSize) {
        ThreadPoolContainerImpl threadPoolContainerImpl = this;
        synchronized (threadPoolContainerImpl) {
            if (this.shutdown) {
                return;
            }
            this.shutdown();
            this.executorService = new ThreadPoolExecutor(newPoolSize, newPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.shutdown = false;
        }
    }

    @Override
    public ThreadPoolExecutor getThreadPool() {
        return this.executorService;
    }
}

