/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.threadpool.asynchronous.impl;

import com.xunlei.channel.sms.threadpool.asynchronous.AsynchronousInvokerService;
import com.xunlei.channel.sms.threadpool.asynchronous.AsynchronousThreadMonitor;
import com.xunlei.channel.sms.threadpool.asynchronous.FutureMonitor;
import com.xunlei.channel.sms.threadpool.asynchronous.MonitorUnit;
import com.xunlei.channel.sms.threadpool.asynchronous.Timer;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousThreadMonitorImpl
implements AsynchronousThreadMonitor,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AsynchronousThreadMonitorImpl.class);
    private ConcurrentHashMap<Class<?>, MonitorUnit> monitorMap = new ConcurrentHashMap();
    private Thread thread;
    private AsynchronousInvokerService asynchronousInvoker;
    private boolean monitor = true;
    private long timeout = 0L;
    private TimeUnit timeoutTimeUnit = TimeUnit.SECONDS;

    public AsynchronousThreadMonitorImpl(AsynchronousInvokerService asynchronousInvoker) {
        this.asynchronousInvoker = asynchronousInvoker;
    }

    @Override
    public void run() {
        while (this.monitor && !this.thread.isInterrupted()) {
            this.monitor();
        }
    }

    private void monitor() {
        Future<Boolean> future;
        BlockingQueue<FutureMonitor<Boolean>> futures = this.asynchronousInvoker.futureBlockingQueue();
        FutureMonitor<Boolean> take = null;
        try {
            take = futures.take();
        }
        catch (InterruptedException e) {
            logger.error("Take future monitor error with message: " + e.getMessage(), (Throwable)e);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Took a monitor: {}", take);
        }
        if ((future = take.getFuture()) == null) {
            return;
        }
        Callable<Boolean> callable = take.getCallable();
        MonitorUnit monitorUnit = this.getOrInitMonitorUnit(callable);
        Timer timer = Timer.newTimer();
        try {
            Boolean completed = this.timeout > 0L ? future.get(this.timeout, this.timeoutTimeUnit) : future.get();
            if (completed == null) {
                monitorUnit.timeout(timer.time());
            } else if (!completed.booleanValue()) {
                monitorUnit.fail(timer.time());
            } else {
                monitorUnit.success(timer.time());
            }
        }
        catch (InterruptedException e) {
            logger.error("Caught exception when get invoke result with message: " + e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error("Caught exception when get invoke result with message: " + e.getMessage(), (Throwable)e);
            monitorUnit.fail(timer.time());
        }
        catch (TimeoutException e) {
            monitorUnit.timeout(timer.time());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MonitorUnit getOrInitMonitorUnit(Callable<Boolean> callable) {
        MonitorUnit monitorUnit = this.monitorMap.get(callable.getClass());
        if (monitorUnit == null) {
            Class<?> clazz = callable.getClass();
            synchronized (clazz) {
                if (this.monitorMap.get(callable.getClass()) == null) {
                    monitorUnit = new MonitorUnit(callable.getClass());
                    this.monitorMap.put(callable.getClass(), monitorUnit);
                } else {
                    monitorUnit = this.monitorMap.get(callable.getClass());
                }
            }
        }
        return monitorUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startMonitor() {
        AsynchronousThreadMonitorImpl asynchronousThreadMonitorImpl = this;
        synchronized (asynchronousThreadMonitorImpl) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopMonitor() {
        AsynchronousThreadMonitorImpl asynchronousThreadMonitorImpl = this;
        synchronized (asynchronousThreadMonitorImpl) {
            this.monitor = false;
            this.thread.interrupt();
        }
    }

    @Override
    public int waitThreadSize() {
        ThreadPoolExecutor threadPool = this.asynchronousInvoker.getThreadPool();
        if (threadPool == null) {
            return 0;
        }
        BlockingQueue<Runnable> queue = threadPool.getQueue();
        if (queue == null) {
            return 0;
        }
        int size = queue.size();
        if (logger.isDebugEnabled()) {
            logger.debug("Getting wait thread size with: {}", (Object)size);
        }
        return this.asynchronousInvoker.getThreadPool().getQueue().size();
    }

    @Override
    public long averageExecuteTime() {
        Collection<MonitorUnit> values = this.monitorMap.values();
        if (values.isEmpty()) {
            return 0L;
        }
        BigDecimal countSum = new BigDecimal(0);
        BigDecimal averageSum = new BigDecimal(0);
        for (MonitorUnit value : values) {
            BigDecimal count = value.getCount();
            countSum = countSum.add(count);
            BigDecimal averageTime = value.getAverageTime();
            averageSum = averageSum.add(averageTime);
        }
        if (countSum.longValue() == 0L) {
            return 0L;
        }
        BigDecimal divide = MonitorUnit.divide(averageSum, countSum);
        return divide.longValue();
    }

    @Override
    public long timeOutSize() {
        Collection<MonitorUnit> values = this.monitorMap.values();
        if (values.isEmpty()) {
            return 0L;
        }
        BigDecimal countSum = new BigDecimal(0);
        for (MonitorUnit value : values) {
            BigDecimal count = value.getTimeoutCount();
            countSum = countSum.add(count);
        }
        return countSum.longValue();
    }

    @Override
    public Map<Class<?>, MonitorUnit> getMonitorMap() {
        return this.monitorMap;
    }
}

