/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.threadpool.asynchronous.impl;

import com.xunlei.channel.sms.threadpool.asynchronous.AsynchronousInvokerService;
import com.xunlei.channel.sms.threadpool.asynchronous.FutureMonitor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousInvokerServiceImpl
implements AsynchronousInvokerService {
    private static final Logger logger = LoggerFactory.getLogger(AsynchronousInvokerServiceImpl.class);
    private ThreadPoolExecutor executorService = new ThreadPoolExecutor(1, 10, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private BlockingQueue<FutureMonitor<Boolean>> futureBlockingQueue = new LinkedBlockingQueue<FutureMonitor<Boolean>>();

    @Override
    public boolean submit(Callable<Boolean> callable) {
        Future<Boolean> submit = this.executorService.submit(callable);
        FutureMonitor<Boolean> futureMonitor = new FutureMonitor<Boolean>();
        futureMonitor.setCallable(callable);
        futureMonitor.setFuture(submit);
        boolean added = this.futureBlockingQueue.add(futureMonitor);
        if (added) {
            if (logger.isDebugEnabled()) {
                logger.debug("Submitted a callable to thread pool! callable: {} thread pool status: {}", callable, (Object)this.executorService);
            }
        } else {
            logger.error("Submit callable: {} to thread pool error! Thread pool status: {}", callable, (Object)this.executorService);
        }
        return added;
    }

    @Override
    public BlockingQueue<FutureMonitor<Boolean>> futureBlockingQueue() {
        return this.futureBlockingQueue;
    }

    @Override
    public ThreadPoolExecutor getThreadPool() {
        return this.executorService;
    }
}

