/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.threadpool.asynchronous;

import java.math.BigDecimal;

public class MonitorUnit {
    private Class<?> clazz;
    private BigDecimal averageTime = new BigDecimal(0);
    private BigDecimal count = new BigDecimal(0);
    private BigDecimal successAverageTime = new BigDecimal(0);
    private BigDecimal successCount = new BigDecimal(0);
    private BigDecimal failedAverageTime = new BigDecimal(0);
    private BigDecimal failedCount = new BigDecimal(0);
    private BigDecimal timeoutCount = new BigDecimal(0);
    private BigDecimal timeOutAverageTime = new BigDecimal(0);

    public MonitorUnit(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void success(long time) {
        BigDecimal[] bigDecimals = MonitorUnit.calculateAverage(this.successAverageTime, this.successCount, time);
        this.successAverageTime = bigDecimals[0];
        this.successCount = bigDecimals[1];
        this.invoked(time);
    }

    public void fail(long time) {
        BigDecimal[] bigDecimals = MonitorUnit.calculateAverage(this.failedAverageTime, this.failedCount, time);
        this.failedAverageTime = bigDecimals[0];
        this.failedCount = bigDecimals[1];
        this.invoked(time);
    }

    public void timeout(long time) {
        BigDecimal[] bigDecimals = MonitorUnit.calculateAverage(this.timeOutAverageTime, this.timeoutCount, time);
        this.timeOutAverageTime = bigDecimals[0];
        this.timeoutCount = bigDecimals[1];
        this.invoked(time);
    }

    public void invoked(long time) {
        BigDecimal[] bigDecimals = MonitorUnit.calculateAverage(this.averageTime, this.count, time);
        this.averageTime = bigDecimals[0];
        this.count = bigDecimals[1];
    }

    public static BigDecimal[] calculateAverage(BigDecimal averageTime, BigDecimal count, long newTime) {
        BigDecimal[] bigDecimals = new BigDecimal[2];
        BigDecimal sumDecimal = averageTime.multiply(count);
        bigDecimals[1] = count = count.add(new BigDecimal(1));
        BigDecimal timeDecimal = new BigDecimal(newTime);
        sumDecimal = sumDecimal.add(timeDecimal);
        bigDecimals[0] = averageTime = sumDecimal.divide(count, 2, 4);
        return bigDecimals;
    }

    public static BigDecimal divide(BigDecimal dividend, BigDecimal divisor) {
        BigDecimal result = dividend.divide(divisor, 2, 4);
        return result;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public BigDecimal getAverageTime() {
        return this.averageTime;
    }

    public void setAverageTime(BigDecimal averageTime) {
        this.averageTime = averageTime;
    }

    public BigDecimal getCount() {
        return this.count;
    }

    public void setCount(BigDecimal count) {
        this.count = count;
    }

    public BigDecimal getSuccessAverageTime() {
        return this.successAverageTime;
    }

    public void setSuccessAverageTime(BigDecimal successAverageTime) {
        this.successAverageTime = successAverageTime;
    }

    public BigDecimal getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(BigDecimal successCount) {
        this.successCount = successCount;
    }

    public BigDecimal getFailedAverageTime() {
        return this.failedAverageTime;
    }

    public void setFailedAverageTime(BigDecimal failedAverageTime) {
        this.failedAverageTime = failedAverageTime;
    }

    public BigDecimal getFailedCount() {
        return this.failedCount;
    }

    public void setFailedCount(BigDecimal failedCount) {
        this.failedCount = failedCount;
    }

    public BigDecimal getTimeoutCount() {
        return this.timeoutCount;
    }

    public void setTimeoutCount(BigDecimal timeoutCount) {
        this.timeoutCount = timeoutCount;
    }

    public BigDecimal getTimeOutAverageTime() {
        return this.timeOutAverageTime;
    }

    public void setTimeOutAverageTime(BigDecimal timeOutAverageTime) {
        this.timeOutAverageTime = timeOutAverageTime;
    }

    public String toString() {
        return "MonitorUnit{clazz=" + this.clazz + ", averageTime=" + this.averageTime + ", count=" + this.count + ", successAverageTime=" + this.successAverageTime + ", successCount=" + this.successCount + ", failedAverageTime=" + this.failedAverageTime + ", failedCount=" + this.failedCount + ", timeoutCount=" + this.timeoutCount + ", timeOutAverageTime=" + this.timeOutAverageTime + '}';
    }
}

