/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.risk.threathunter.constant;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ThreatHunterRiskResult {
    OK(0),
    WARN(5),
    ERROR(9);

    private static final Logger logger;
    int code;

    private ThreatHunterRiskResult(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public boolean isOK() {
        return this.code == ThreatHunterRiskResult.OK.code;
    }

    public static ThreatHunterRiskResult result(Integer code) {
        if (code == null) {
            logger.error("Returns ok result because code is null!");
            return OK;
        }
        for (ThreatHunterRiskResult threatHunterRiskResult : ThreatHunterRiskResult.values()) {
            if (threatHunterRiskResult.getCode() != code.intValue()) continue;
            logger.info("Found threatHunterRiskResult: {} by code: {}", (Object)threatHunterRiskResult, (Object)code);
            return threatHunterRiskResult;
        }
        logger.error("Could'nt found threatHunterRiskResult of code: {}", (Object)code);
        return ERROR;
    }

    static {
        logger = LoggerFactory.getLogger(ThreatHunterRiskResult.class);
    }
}

