/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.risk.threathunter;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.xunlei.channel.sms.risk.threathunter.ThreatHunterCallable;
import com.xunlei.channel.sms.risk.threathunter.ThreatHunterConfig;
import com.xunlei.channel.sms.risk.threathunter.entity.MobileRiskResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ThreatHunterService
implements InitializingBean,
Thread.UncaughtExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(ThreatHunterService.class);
    @Autowired
    private ThreatHunterConfig threatHunterConfig;
    private ThreadPoolExecutor threadPoolExecutor;

    public Map<String, MobileRiskResult> requestAndGetMap(String ... mobile) {
        Collection<MobileRiskResult> mobileRiskResults = this.requestAndReturnRiskResult(mobile);
        if (CollectionUtils.isEmpty(mobileRiskResults)) {
            logger.warn("Could'nt found risk results of mobile: {}", (Object)Arrays.toString(mobile));
            return null;
        }
        HashMap<String, MobileRiskResult> mobileResultMap = new HashMap<String, MobileRiskResult>(mobileRiskResults.size());
        for (MobileRiskResult mobileRiskResult : mobileRiskResults) {
            String mobileNumber = mobileRiskResult.getMobile();
            mobileResultMap.put(mobileNumber, mobileRiskResult);
        }
        return mobileResultMap;
    }

    public Collection<MobileRiskResult> requestAndReturnRiskResult(String ... mobile) {
        if (mobile == null || mobile.length == 0) {
            return null;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Submitting threat hunter query task with mobile: {}", (Object)Arrays.toString(mobile));
            }
            ThreatHunterCallable threatHunterCallable = new ThreatHunterCallable(mobile, this.threatHunterConfig);
            Future<Collection<MobileRiskResult>> future = this.threadPoolExecutor.submit(threatHunterCallable);
            if (logger.isDebugEnabled()) {
                logger.debug("Submitted query task and returns future: {}", future);
            }
            Collection<MobileRiskResult> riskResults = future.get(this.threatHunterConfig.getTimeoutMills().intValue(), TimeUnit.MILLISECONDS);
            if (logger.isDebugEnabled()) {
                logger.debug("Return query result: {} of mobile: {}", riskResults, (Object)Arrays.toString(mobile));
            }
            return riskResults;
        }
        catch (Exception e) {
            logger.error("Error happened when query mobile: " + Arrays.toString(mobile) + " error message: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("threat-hunter-risk-pool-").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)this).build();
        this.threadPoolExecutor = new ThreadPoolExecutor(2, 10, (long)this.threatHunterConfig.getTimeoutMills().intValue(), TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(100, true), threadFactory);
        logger.info("Initialized thread pool of ThreatHunterRisk!");
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        logger.error("Error happened on thread: " + t + " with message: " + e.getMessage(), e);
    }
}

