/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.risk.threathunter;

import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.interceptor.result.InterceptResult;
import com.xunlei.channel.sms.risk.RiskClient;
import com.xunlei.channel.sms.risk.threathunter.ThreatHunterService;
import com.xunlei.channel.sms.risk.threathunter.constant.ThreatHunterRiskResult;
import com.xunlei.channel.sms.risk.threathunter.entity.MobileRiskResult;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ThreatHunterRiskClient
implements RiskClient {
    private static final Logger logger = LoggerFactory.getLogger(ThreatHunterRiskClient.class);
    @Autowired
    private ThreatHunterService threatHunterService;

    @Override
    public InterceptResult intercept(SmsMessageRequest messageRequest) {
        String mobile = messageRequest.getMobile();
        if (StringUtils.isEmpty((Object)mobile)) {
            logger.warn("Message request: {} need risk, but it's batch send request!", (Object)messageRequest);
            return InterceptResult.SUCCESS;
        }
        try {
            Map<String, MobileRiskResult> riskResultMap = this.threatHunterService.requestAndGetMap(mobile);
            if (logger.isDebugEnabled()) {
                logger.debug("Return query result: {} of mobile: {}", riskResultMap, (Object)mobile);
            }
            if (CollectionUtils.isEmpty(riskResultMap)) {
                logger.warn("Null result of mobile: {}", (Object)mobile);
                return InterceptResult.SUCCESS;
            }
            MobileRiskResult mobileRiskResult = riskResultMap.get(mobile);
            ThreatHunterRiskResult riskResult = mobileRiskResult.getRiskResult();
            if (!ThreatHunterRiskResult.ERROR.equals((Object)riskResult)) {
                return InterceptResult.SUCCESS;
            }
            logger.info("Found black mobile no: {}", (Object)mobile);
            return InterceptResult.INTERCEPTOR_BLACK_CARD_LIMITER;
        }
        catch (Exception e) {
            logger.error("Error happened when query mobile: " + mobile + " error message: " + e.getMessage(), (Throwable)e);
            return InterceptResult.SUCCESS;
        }
    }
}

