/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.risk.threathunter;

import com.google.common.base.Optional;
import com.xunlei.channel.sms.risk.threathunter.constant.ThreatHunterRiskResult;
import com.xunlei.channel.sms.risk.threathunter.entity.MobileRiskResult;
import com.xunlei.channel.sms.risk.threathunter.entity.ThreatHunterRequest;
import com.xunlei.channel.sms.risk.threathunter.entity.ThreatHunterRequestUser;
import com.xunlei.channel.sms.risk.threathunter.entity.ThreatHunterResponse;
import com.xunlei.channel.sms.risk.threathunter.entity.ThreatHunterResponseUser;
import com.xunlei.channel.sms.util.JacksonHelper;
import com.xunlei.channel.sms.util.http.HttpUtils;
import com.xunlei.channel.sms.util.security.AESCFBEncrypt;
import com.xunlei.channel.sms.util.security.SHA1Encrypt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThreatHunterClient {
    private static final Logger logger = LoggerFactory.getLogger(ThreatHunterClient.class);

    public static Optional<Collection<MobileRiskResult>> send(String url, int timeout, String user, String key, String ... mobile) throws Exception {
        if (mobile == null || mobile.length <= 0) {
            return Optional.absent();
        }
        String requestData = ThreatHunterClient.getRequestString(user, key, mobile);
        String response = ThreatHunterClient.post(url, requestData, timeout);
        Map<String, ThreatHunterRiskResult> riskResultMap = ThreatHunterClient.parseResponse(key, response);
        Collection<MobileRiskResult> mobileRiskResults = ThreatHunterClient.convertShaResultToMobileRiskResults(mobile, riskResultMap);
        if (mobileRiskResults == null) {
            return Optional.absent();
        }
        return Optional.of(mobileRiskResults);
    }

    private static Collection<MobileRiskResult> convertShaResultToMobileRiskResults(String[] mobiles, Map<String, ThreatHunterRiskResult> riskResultMap) throws Exception {
        ArrayList<MobileRiskResult> mobileRiskResults = new ArrayList<MobileRiskResult>(mobiles.length);
        for (String mobile : mobiles) {
            String encrypt = SHA1Encrypt.encrypt((String)mobile, (String)"utf-8");
            ThreatHunterRiskResult threatHunterRiskResult = riskResultMap.get(encrypt);
            if (threatHunterRiskResult == null) {
                logger.warn("No risk result found with mobile: {}", (Object)mobile);
                continue;
            }
            MobileRiskResult mobileRiskResult = new MobileRiskResult();
            mobileRiskResult.setMobile(mobile);
            mobileRiskResult.setRiskResult(threatHunterRiskResult);
            mobileRiskResult.setRiskScore(threatHunterRiskResult.getCode());
            mobileRiskResults.add(mobileRiskResult);
        }
        return mobileRiskResults;
    }

    public static Map<String, ThreatHunterRiskResult> parseResponse(String key, String response) throws Exception {
        if (response == null) {
            return null;
        }
        ThreatHunterResponse threatHunterResponse = (ThreatHunterResponse)JacksonHelper.convertJsonByClass((String)response, ThreatHunterResponse.class);
        if (!threatHunterResponse.isSuccess()) {
            logger.warn("Error status of threat hunter request! response: {}", (Object)threatHunterResponse);
            return null;
        }
        String data = threatHunterResponse.getData();
        Map<String, ThreatHunterRiskResult> riskResultMap = ThreatHunterClient.parseUsersResponse(data, key);
        if (logger.isDebugEnabled()) {
            logger.debug("Parse encrypted data: {} to result: {}", (Object)data, riskResultMap);
        }
        return riskResultMap;
    }

    private static Map<String, ThreatHunterRiskResult> parseUsersResponse(String data, String key) throws Exception {
        String usersJson = AESCFBEncrypt.decryptFromBase64((String)key, (String)data);
        List users = JacksonHelper.convertJsonToListByRawType((String)usersJson, ThreatHunterResponseUser.class);
        HashMap<String, ThreatHunterRiskResult> riskResultMap = new HashMap<String, ThreatHunterRiskResult>();
        for (ThreatHunterResponseUser user : users) {
            String userString = user.getUser();
            Integer risk = user.getRisk();
            ThreatHunterRiskResult result = ThreatHunterRiskResult.result(risk);
            if (logger.isDebugEnabled()) {
                logger.debug("Found result: {} of mobile: {}", (Object)result, (Object)userString);
            }
            riskResultMap.put(userString, result);
        }
        return riskResultMap;
    }

    public static String post(String url, String json, int timeout) {
        StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
        String response = null;
        try {
            response = ThreatHunterClient.post(url, (HttpEntity)entity, "UTF-8", timeout);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Post request: {} and get response: {}", (Object)json, (Object)response);
        }
        return response;
    }

    private static String post(String postUrl, HttpEntity reqEntity, String charset, int timeout) throws Exception {
        HttpPost httpPost = new HttpPost(postUrl);
        httpPost.setEntity(reqEntity);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setDefaultRequestConfig(requestConfig).build();
        CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        String response = HttpUtils.readResponse((HttpResponse)httpResponse, (String)"UTF-8");
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("Sent post to url: {} with request: {}", (Object)postUrl, (Object)EntityUtils.toString((HttpEntity)reqEntity, (String)charset));
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
        }
        return response;
    }

    public static String getRequestString(String user, String key, String ... mobile) throws Exception {
        String usersData = ThreatHunterClient.getUsersData(key, mobile);
        String requestData = ThreatHunterClient.getRequestJson(user, usersData);
        return requestData;
    }

    public static String getUsersData(String key, String ... mobile) throws Exception {
        List<ThreatHunterRequestUser> threatHunterRequestUsers = ThreatHunterClient.convertMobileToThreatHunterRequestUsers(mobile);
        String base64 = ThreatHunterClient.encryptData(threatHunterRequestUsers, key);
        return base64;
    }

    public static String getRequestJson(String user, String usersData) {
        ThreatHunterRequest threatHunterRequest = new ThreatHunterRequest();
        threatHunterRequest.setData(usersData);
        threatHunterRequest.setSnUser(user);
        String json = JacksonHelper.getJsonString((Object)threatHunterRequest);
        return json;
    }

    private static String encryptData(List<ThreatHunterRequestUser> threatHunterRequestUsers, String key) throws Exception {
        String json = JacksonHelper.getJsonString(threatHunterRequestUsers);
        String base64 = AESCFBEncrypt.encryptToBase64((String)key, (String)json);
        return base64;
    }

    private static List<ThreatHunterRequestUser> convertMobileToThreatHunterRequestUsers(String ... mobiles) throws Exception {
        ArrayList<ThreatHunterRequestUser> threatHunterRequestUsers = new ArrayList<ThreatHunterRequestUser>(mobiles.length);
        for (String mobile : mobiles) {
            ThreatHunterRequestUser threatHunterRequestUser = new ThreatHunterRequestUser();
            String shaMobile = SHA1Encrypt.encrypt((String)mobile, (String)"UTF-8");
            threatHunterRequestUser.setUser(shaMobile);
            threatHunterRequestUsers.add(threatHunterRequestUser);
        }
        return threatHunterRequestUsers;
    }
}

