/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.risk.threathunter;

import com.google.common.base.Optional;
import com.xunlei.channel.sms.risk.threathunter.ThreatHunterClient;
import com.xunlei.channel.sms.risk.threathunter.ThreatHunterConfig;
import com.xunlei.channel.sms.risk.threathunter.entity.MobileRiskResult;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreatHunterCallable
implements Callable<Collection<MobileRiskResult>> {
    private static final Logger logger = LoggerFactory.getLogger(ThreatHunterCallable.class);
    private String[] mobile;
    private ThreatHunterConfig threatHunterConfig;

    public ThreatHunterCallable(String[] mobile, ThreatHunterConfig threatHunterConfig) {
        this.mobile = mobile;
        this.threatHunterConfig = threatHunterConfig;
    }

    @Override
    public Collection<MobileRiskResult> call() throws Exception {
        try {
            Collection<MobileRiskResult> mobileRiskResults = this.sendRequest(this.mobile);
            if (logger.isDebugEnabled()) {
                logger.debug("Return risk result: {} by mobile: {}", mobileRiskResults, (Object)this.mobile);
            }
            return mobileRiskResults;
        }
        catch (Exception e) {
            logger.error("Error when send threat hunter request with mobile: " + this.mobile + "! message: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Collection<MobileRiskResult> sendRequest(String ... mobile) {
        String user = this.threatHunterConfig.getUser();
        String key = this.threatHunterConfig.getKey();
        String phoneNoUrl = this.threatHunterConfig.getPhoneNoUrl();
        Integer timeoutMills = this.threatHunterConfig.getTimeoutMills();
        try {
            Optional<Collection<MobileRiskResult>> result = ThreatHunterClient.send(phoneNoUrl, timeoutMills, user, key, mobile);
            if (result.isPresent()) {
                return (Collection)result.get();
            }
            return null;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }
}

