/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.mt.impl;

import com.xunlei.channel.sms.client.SpClient;
import com.xunlei.channel.sms.client.manager.SpClientManager;
import com.xunlei.channel.sms.entity.SmsMessageRequest;
import com.xunlei.channel.sms.mt.MtHandler;
import com.xunlei.channel.sms.mt.MtStatusCallback;
import com.xunlei.channel.sms.threadpool.asynchronous.Timer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class MtHandlerImpl
implements MtHandler,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(MtHandlerImpl.class);
    private SpClientManager spClientManager;
    private MtStatusCallback mtStatusCallback;
    private long warningDurationMillSeconds = 10000L;

    public MtHandlerImpl(SpClientManager spClientManager, MtStatusCallback mtStatusCallback) {
        this.spClientManager = spClientManager;
        this.mtStatusCallback = mtStatusCallback;
    }

    @Override
    public void mt(List<SmsMessageRequest> messages) {
        Map<String, List<SmsMessageRequest>> spIdAndMessages = this.getSpIdAndMessages(messages);
        for (Map.Entry<String, List<SmsMessageRequest>> entry : spIdAndMessages.entrySet()) {
            long time;
            String spId = entry.getKey();
            List<SmsMessageRequest> messageRequests = entry.getValue();
            SpClient spClient = this.spClientManager.getSpClient(spId);
            if (spClient == null) {
                logger.warn("Could'nt found spClient by spId: {} so messages skip to send: {}", (Object)spId, messageRequests);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Sending messages: {} by spClient: {}", messageRequests, (Object)spClient);
            }
            Timer timer = Timer.newTimer();
            try {
                spClient.sendSmsMessage(spId, messageRequests);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
            if ((time = timer.time()) <= this.warningDurationMillSeconds) continue;
            logger.warn("Warning timeout! Use: {} ms send to sp: {} and messages is: {}", new Object[]{time, spId, messages});
        }
    }

    private Map<String, List<SmsMessageRequest>> getSpIdAndMessages(List<SmsMessageRequest> messages) {
        HashMap<String, List<SmsMessageRequest>> spIdAndMessageMap = new HashMap<String, List<SmsMessageRequest>>();
        for (SmsMessageRequest message : messages) {
            ArrayList<SmsMessageRequest> smsMessageRequests;
            if (message == null) continue;
            String spId = message.getSpId();
            if (spId == null) {
                logger.warn("No spId presents in message: {}", (Object)message);
            }
            if ((smsMessageRequests = (ArrayList<SmsMessageRequest>)spIdAndMessageMap.get(spId)) == null) {
                smsMessageRequests = new ArrayList<SmsMessageRequest>();
                spIdAndMessageMap.put(spId, smsMessageRequests);
            }
            smsMessageRequests.add(message);
        }
        return spIdAndMessageMap;
    }

    public void afterPropertiesSet() throws Exception {
        this.spClientManager.reloadConfig();
        this.spClientManager.setStatusCallBack(this.mtStatusCallback);
    }

    public long getWarningDurationMillSeconds() {
        return this.warningDurationMillSeconds;
    }

    public void setWarningDurationMillSeconds(long warningDurationMillSeconds) {
        this.warningDurationMillSeconds = warningDurationMillSeconds;
    }
}

