/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.client.sp.zhongde.client;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.xunlei.channel.sms.client.sp.zhongde.vo.ZhongDeMessageRequest;
import com.xunlei.channel.sms.client.sp.zhongde.vo.ZhongDeMessageResponse;
import com.xunlei.channel.sms.client.sp.zhongde.vo.ZhongDeMoMessgageResponse;
import com.xunlei.channel.sms.client.sp.zhongde.vo.ZhongDeMoMessgageResult;
import com.xunlei.channel.sms.client.sp.zhongde.vo.ZhongDeMtStatusMessgageResponse;
import com.xunlei.channel.sms.client.sp.zhongde.vo.ZhongDeMtStatusMessgageResult;
import com.xunlei.channel.sms.constants.SmsStatus;
import com.xunlei.channel.sms.entity.MtResult;
import com.xunlei.channel.sms.util.XmlHelper;
import com.xunlei.channel.sms.util.http.HttpParameterHandler;
import com.xunlei.channel.sms.util.http.ParameteredHttpUtils;
import com.xunlei.channel.sms.vo.MoMessage;
import com.xunlei.channel.sms.vo.MtStatusMessage;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ZhongDeClient {
    private static final Logger logger = LoggerFactory.getLogger(ZhongDeClient.class);
    private HttpParameterHandler<ZhongDeMessageRequest> zhongDeMessageRequestHttpParameterHandler = new HttpParameterHandler(ZhongDeMessageRequest.class);
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final String STATUS = "0";
    private static final String SPLIT = "#@#";
    private static final String SMS_STATUS = "10";
    private static final String REGEX = ",";
    private static ThreadLocal<Integer> mobilesNums = new ThreadLocal();

    public List<MtResult> sendMessage(String apiUrl, String action, String account, String password, String extno, List<SmsMessage> smsMessages) throws IOException {
        Assert.notEmpty(smsMessages, (String)"smsMessages could'nt be null");
        String mobiles = this.mergeMobiles(smsMessages);
        Assert.notNull((Object)mobiles, (String)"mobiles could'nt be null");
        if (logger.isDebugEnabled()) {
            logger.debug("Batch send message: {}", smsMessages);
        }
        ZhongDeMessageRequest zhongDeMessageRequest = new ZhongDeMessageRequest();
        zhongDeMessageRequest.setAccount(account);
        zhongDeMessageRequest.setAction(action);
        zhongDeMessageRequest.setContent(smsMessages.get(0).getContent());
        zhongDeMessageRequest.setExtno(extno);
        zhongDeMessageRequest.setMobile(mobiles);
        zhongDeMessageRequest.setPassword(password);
        String response = ParameteredHttpUtils.doPost(this.zhongDeMessageRequestHttpParameterHandler, (Object)zhongDeMessageRequest, (String)apiUrl, (String)"UTF-8", (int)10000);
        List<MtResult> mtResults = this.parseResponseToSmsMessage(response, smsMessages);
        return mtResults;
    }

    public List<MtStatusMessage> getMtStatusMessages(String apiUrl, String action, String account, String password, String spClass) throws IOException {
        ZhongDeMessageRequest zhongDeMessageRequest = new ZhongDeMessageRequest();
        zhongDeMessageRequest.setAccount(account);
        zhongDeMessageRequest.setAction(action);
        zhongDeMessageRequest.setPassword(password);
        String response = ParameteredHttpUtils.doPost(this.zhongDeMessageRequestHttpParameterHandler, (Object)zhongDeMessageRequest, (String)apiUrl, (String)"UTF-8", (int)10000);
        List<MtStatusMessage> mtStatusMessages = this.parseResponseToMtStatusMessages(response, spClass);
        return mtStatusMessages;
    }

    public List<MoMessage> getMoMessages(String apiUrl, String action, String account, String password, String spId) throws IOException {
        ZhongDeMessageRequest zhongDeMessageRequest = new ZhongDeMessageRequest();
        zhongDeMessageRequest.setAccount(account);
        zhongDeMessageRequest.setAction(action);
        zhongDeMessageRequest.setPassword(password);
        String response = ParameteredHttpUtils.doPost(this.zhongDeMessageRequestHttpParameterHandler, (Object)zhongDeMessageRequest, (String)apiUrl, (String)"UTF-8", (int)10000);
        List<MoMessage> moMessages = this.parseResponseToMoMessages(response, spId);
        return moMessages;
    }

    private List<MoMessage> parseResponseToMoMessages(String response, String spId) {
        ArrayList moMessages = Lists.newArrayList();
        ZhongDeMoMessgageResponse zhongDeMoMessgageResponse = null;
        try {
            zhongDeMoMessgageResponse = (ZhongDeMoMessgageResponse)XmlHelper.convertXmlByClass((String)response, ZhongDeMoMessgageResponse.class);
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("response:{} and convert to zhongDeMoMessgageResponse:{}", (Object)response, (Object)zhongDeMoMessgageResponse.toString());
            }
            return moMessages;
        }
        if (zhongDeMoMessgageResponse == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("zhongDeMoMessgageResponse : is null ");
            }
            return moMessages;
        }
        Assert.notNull((Object)zhongDeMoMessgageResponse, (String)"zhongDeMoMessgageResponse could'nt be null");
        Optional zhongDeMoMessgageResults = Optional.fromNullable(zhongDeMoMessgageResponse.getZhongDeMoMessgageResults());
        if (!zhongDeMoMessgageResults.isPresent()) {
            if (logger.isDebugEnabled()) {
                logger.debug("zhongDeMoMessgageResults is null");
            }
            return moMessages;
        }
        for (ZhongDeMoMessgageResult zhongDeMtStatusMessgageResult : (List)zhongDeMoMessgageResults.get()) {
            MoMessage moMessage = new MoMessage();
            moMessage.setSpId(spId);
            moMessage.setReceiveTime(zhongDeMtStatusMessgageResult.getReceiveTime());
            moMessage.setMobile(zhongDeMtStatusMessgageResult.getMobile());
            moMessage.setContent(zhongDeMtStatusMessgageResult.getContent());
            moMessage.setSpMessageId(zhongDeMtStatusMessgageResult.getTaskId());
            moMessages.add(moMessage);
        }
        return moMessages;
    }

    private List<MtStatusMessage> parseResponseToMtStatusMessages(String response, String spClass) {
        ArrayList mtStatusMessages = Lists.newArrayList();
        ZhongDeMtStatusMessgageResponse zhongDeMtStatusMessgageResponse = null;
        try {
            zhongDeMtStatusMessgageResponse = (ZhongDeMtStatusMessgageResponse)XmlHelper.convertXmlByClass((String)response, ZhongDeMtStatusMessgageResponse.class);
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("response:{} and convert to ZhongDeMtStatusMessgageResponse:{}", (Object)response, (Object)zhongDeMtStatusMessgageResponse.toString());
            }
            return mtStatusMessages;
        }
        Assert.notNull((Object)zhongDeMtStatusMessgageResponse, (String)"zhongDeMtStatusMessgageResponse could'nt be null");
        Optional zhongDeMtStatusMessgageResults = Optional.fromNullable(zhongDeMtStatusMessgageResponse.getZhongDeMtStatusMessgageResults());
        if (!zhongDeMtStatusMessgageResults.isPresent()) {
            if (logger.isDebugEnabled()) {
                logger.debug("ZhongDeMtStatusMessgageResult : is null or Empty");
            }
            return mtStatusMessages;
        }
        for (ZhongDeMtStatusMessgageResult zhongDeMtStatusMessgageResult : (List)zhongDeMtStatusMessgageResults.get()) {
            MtStatusMessage mtStatusMessage = new MtStatusMessage();
            mtStatusMessage.setSpClass(spClass);
            mtStatusMessage.setMobile(zhongDeMtStatusMessgageResult.getMobile());
            mtStatusMessage.setReceiveTime(zhongDeMtStatusMessgageResult.getReceiveTime());
            mtStatusMessage.setResult(zhongDeMtStatusMessgageResult.getErrorCode());
            String taskId = zhongDeMtStatusMessgageResult.getTaskId();
            mtStatusMessage.setSpMessageId(mtStatusMessage.buildSpMessageId(taskId));
            if (SMS_STATUS.equals(zhongDeMtStatusMessgageResult.getStatus())) {
                mtStatusMessage.setSmsStatus(SmsStatus.TOUCH.getStatus());
            } else {
                mtStatusMessage.setSmsStatus(SmsStatus.NO_TOUCH.getStatus());
            }
            mtStatusMessages.add(mtStatusMessage);
        }
        return mtStatusMessages;
    }

    private List<MtResult> parseResponseToSmsMessage(String response, List<SmsMessage> smsMessages) throws IOException {
        ZhongDeMessageResponse zhongDeMessageResponse = (ZhongDeMessageResponse)XmlHelper.convertXmlByClass((String)response, ZhongDeMessageResponse.class);
        if (logger.isDebugEnabled()) {
            logger.debug("response:{} and convert to zhongDeMessageResponse:{}", (Object)response, (Object)zhongDeMessageResponse.toString());
        }
        Assert.notNull((Object)zhongDeMessageResponse, (String)"zhongDeMessageResponse could'nt be null");
        int sussesCount = zhongDeMessageResponse.getSuccessCounts();
        if (mobilesNums.get() == sussesCount) {
            String taskID = zhongDeMessageResponse.getTaskID();
            logger.debug("Succeed to send request: {} and response is: {}", smsMessages, (Object)response);
            return MtResult.buildMtResult(smsMessages, (SmsStatus)SmsStatus.SUCCESS, (String)taskID);
        }
        logger.debug("Succeed to send request: {} and response is: {}", smsMessages, (Object)response);
        return MtResult.buildMtResult(smsMessages, (SmsStatus)SmsStatus.FAIL, null);
    }

    private String mergeMobiles(List<SmsMessage> smsMessages) {
        StringBuffer mobiles = new StringBuffer();
        String delimiter = "";
        mobilesNums.set(smsMessages.size());
        for (SmsMessage smsMessage : smsMessages) {
            mobiles.append(delimiter).append(smsMessage.getMobile());
            delimiter = REGEX;
        }
        return mobiles.toString();
    }
}

