/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.client.sp.zhongde;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.xunlei.channel.sms.client.AbstractBatchModeSpClient;
import com.xunlei.channel.sms.client.SpNotSupportModeException;
import com.xunlei.channel.sms.client.constant.SpBatchMode;
import com.xunlei.channel.sms.client.sp.zhongde.client.ZhongDeClient;
import com.xunlei.channel.sms.entity.MtResult;
import com.xunlei.channel.sms.entity.SpInfo;
import com.xunlei.channel.sms.vo.MoMessage;
import com.xunlei.channel.sms.vo.MtStatusMessage;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZhongDeSpClient
extends AbstractBatchModeSpClient {
    private static final Logger logger = LoggerFactory.getLogger(ZhongDeSpClient.class);
    private static final String ACTION_SEND = "send";
    private static final String ACTION_REPORT = "report";
    private static final String ACTION_MO = "mo";
    private ZhongDeClient client = new ZhongDeClient();

    @Override
    protected int maxSameContentBatchSize() {
        return 800;
    }

    @Override
    protected int maxDifferentContentBatchSize() {
        return 0;
    }

    @Override
    protected SpBatchMode[] supportBatchModes() {
        return new SpBatchMode[]{SpBatchMode.SAME_CONTENT};
    }

    @Override
    protected MtResult singleSend(SpInfo spInfo, SmsMessage message) throws Exception {
        throw new SpNotSupportModeException();
    }

    @Override
    protected List<MtResult> sendMultiplyContents(SpInfo spInfo, List<SmsMessage> messages) throws Exception {
        throw new SpNotSupportModeException();
    }

    @Override
    protected List<MtResult> sendSameContentWithMobiles(SpInfo spInfo, List<SmsMessage> messages) throws Exception {
        String apiUrl = spInfo.getApiUrl();
        String account = spInfo.getAccount();
        String password = spInfo.getPassword();
        String extno = spInfo.getExt1();
        return this.client.sendMessage(apiUrl, ACTION_SEND, account, password, extno, messages);
    }

    @Override
    public String spClass() {
        return "zhongde";
    }

    @Override
    public List<MtStatusMessage> getMtStatusMessages(String spId) {
        Optional<SpInfo> spInfoBySpId = this.getSpInfoBySpId(spId);
        if (!spInfoBySpId.isPresent()) {
            logger.error("Not found available for spId: {}", (Object)spId);
            return null;
        }
        SpInfo spInfo = (SpInfo)spInfoBySpId.get();
        String apiUrl = spInfo.getApiUrl();
        String account = spInfo.getAccount();
        String password = spInfo.getPassword();
        List<Object> mtStatusMessages = Lists.newArrayList();
        try {
            mtStatusMessages = this.client.getMtStatusMessages(apiUrl, ACTION_REPORT, account, password, this.spClass());
        }
        catch (Exception e) {
            logger.error("Failed to send getMtStatusMessages: with message: " + e.getMessage(), (Throwable)e);
            return mtStatusMessages;
        }
        return mtStatusMessages;
    }

    @Override
    public List<MoMessage> getMoMessages(String spId) {
        Optional<SpInfo> spInfoBySpId = this.getSpInfoBySpId(spId);
        if (!spInfoBySpId.isPresent()) {
            logger.error("Not found available for spId: {}", (Object)spId);
            return null;
        }
        SpInfo spInfo = (SpInfo)spInfoBySpId.get();
        String apiUrl = spInfo.getApiUrl();
        String account = spInfo.getAccount();
        String password = spInfo.getPassword();
        List<Object> moMessages = Lists.newArrayList();
        try {
            moMessages = this.client.getMoMessages(apiUrl, ACTION_MO, account, password, spId);
        }
        catch (Exception e) {
            logger.error("Failed to send getMoMessages: with message: " + e.getMessage(), (Throwable)e);
            return moMessages;
        }
        return moMessages;
    }
}

