/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.client.sp.ronglian.client;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.xunlei.channel.sms.client.sp.ronglian.vo.RongLianMessageRequest;
import com.xunlei.channel.sms.client.sp.ronglian.vo.RongLianMessageResponse;
import com.xunlei.channel.sms.client.sp.ronglian.vo.RongLianMessageResult;
import com.xunlei.channel.sms.client.sp.ronglian.vo.RongLianMoMessageResponse;
import com.xunlei.channel.sms.client.sp.ronglian.vo.RongLianMoMessageResult;
import com.xunlei.channel.sms.client.sp.ronglian.vo.RongLianMtStatusMessageResponse;
import com.xunlei.channel.sms.client.sp.ronglian.vo.RongLianMtStatusMessageResult;
import com.xunlei.channel.sms.client.sp.ronglian.vo.RongLianVoiceRequest;
import com.xunlei.channel.sms.client.sp.ronglian.vo.RongLianVoiceResponse;
import com.xunlei.channel.sms.client.sp.ronglian.vo.RongLianVoiceResult;
import com.xunlei.channel.sms.constants.SmsStatus;
import com.xunlei.channel.sms.entity.MtResult;
import com.xunlei.channel.sms.util.JacksonHelper;
import com.xunlei.channel.sms.util.http.HttpParameterHandler;
import com.xunlei.channel.sms.util.http.ParameteredHttpUtils;
import com.xunlei.channel.sms.util.sign.SignUtils;
import com.xunlei.channel.sms.vo.MoMessage;
import com.xunlei.channel.sms.vo.MtStatusMessage;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RongLianClient {
    private static final Logger logger = LoggerFactory.getLogger(RongLianClient.class);
    private static final String FORMAT_STRING = "yyyyMMddHHmmss";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final String SEND_ACTION = "SMS/TemplateSMS";
    private static final String GET_ARRIVED_ACTION = "SMS/GetArrived";
    private static final String VOICE_ACTION = "Calls/VoiceVerify";
    private static final String SMS_TYPE_ONE = "1";
    private static final String SMS_TYPE_ZERO = "0";
    private static final String COUNT = "500";
    private static final String SMS_STATUS = "0";
    private static final String REGEX = ",";
    private HttpParameterHandler<RongLianMessageRequest> rongLianMessageRequestHttpParameterHandler = new HttpParameterHandler(RongLianMessageRequest.class);
    private HttpParameterHandler<RongLianVoiceRequest> rongLianVoiceRequestHttpParameterHandler = new HttpParameterHandler(RongLianVoiceRequest.class);

    public List<MtResult> sendMessage(String apiUrl, String appId, String templateId, String accountSid, String token, List<SmsMessage> smsMessages) throws Exception {
        Assert.notEmpty(smsMessages, (String)"smsMessages could'nt be null");
        String mobiles = this.mergeMobiles(smsMessages);
        Assert.notNull((Object)mobiles, (String)"mobiles could'nt be null");
        SmsMessage message = smsMessages.get(0);
        if (logger.isDebugEnabled()) {
            logger.debug("Batch send message: {}", smsMessages);
        }
        RongLianMessageRequest rongLianMessageRequest = new RongLianMessageRequest();
        rongLianMessageRequest.setAppId(appId);
        rongLianMessageRequest.setContent(new String[]{message.getContent()});
        rongLianMessageRequest.setMobiles(mobiles);
        rongLianMessageRequest.setTemplateId(templateId);
        String timeStamp = this.getTimestamp();
        Map<String, String> headers = rongLianMessageRequest.getHeaders(timeStamp, accountSid);
        String sigParameter = SignUtils.md5((String)(accountSid + token + timeStamp), (String)DEFAULT_CHARSET);
        String url = MessageFormat.format(apiUrl, accountSid, SEND_ACTION, sigParameter);
        String json = JacksonHelper.getJsonString((Object)rongLianMessageRequest);
        String response = ParameteredHttpUtils.doPost(this.rongLianMessageRequestHttpParameterHandler, headers, (String)json, (String)url, (String)DEFAULT_CHARSET, (int)10000);
        List<MtResult> mtResults = this.parseMessageResponse(response, smsMessages);
        return mtResults;
    }

    public List<MtStatusMessage> getMtStatusMessages(String apiUrl, String appId, String accountSid, String token, String spClass) throws Exception {
        String response = this.getCallbackMessages(apiUrl, appId, accountSid, token, SMS_TYPE_ONE);
        List<MtStatusMessage> mtStatusMessages = this.parseResponseToMtStatusMessages(response, spClass);
        return mtStatusMessages;
    }

    public List<MoMessage> getMoMessages(String apiUrl, String appId, String accountSid, String token, String spId) throws Exception {
        String response = this.getCallbackMessages(apiUrl, appId, accountSid, token, "0");
        List<MoMessage> moMessages = this.parseResponseToMoMessages(response, spId);
        return moMessages;
    }

    private String getCallbackMessages(String apiUrl, String appId, String accountSid, String token, String smsType) throws Exception {
        RongLianMessageRequest rongLianMessageRequest = new RongLianMessageRequest();
        rongLianMessageRequest.setAppId(appId);
        rongLianMessageRequest.setSmsType(smsType);
        rongLianMessageRequest.setCount(COUNT);
        String timeStamp = this.getTimestamp();
        Map<String, String> headers = rongLianMessageRequest.getHeaders(timeStamp, accountSid);
        String sigParameter = SignUtils.md5((String)(accountSid + token + timeStamp), (String)DEFAULT_CHARSET);
        String url = MessageFormat.format(apiUrl, accountSid, GET_ARRIVED_ACTION, sigParameter);
        String json = JacksonHelper.getJsonString((Object)rongLianMessageRequest);
        String response = ParameteredHttpUtils.doPost(this.rongLianMessageRequestHttpParameterHandler, headers, (String)json, (String)url, (String)DEFAULT_CHARSET, (int)10000);
        return response;
    }

    private List<MtStatusMessage> parseResponseToMtStatusMessages(String response, String spClass) {
        ArrayList mtStatusMessages = Lists.newArrayList();
        RongLianMtStatusMessageResponse rongLianMtStatusMessageResponse = null;
        try {
            rongLianMtStatusMessageResponse = (RongLianMtStatusMessageResponse)JacksonHelper.convertJsonByClass((String)response, RongLianMtStatusMessageResponse.class);
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("response:{} and convert to rongLianMtStatusMessageResponse:{}", (Object)response, (Object)rongLianMtStatusMessageResponse.toString());
            }
            return mtStatusMessages;
        }
        if (rongLianMtStatusMessageResponse == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("rongLianMtStatusMessageResponse : is null ");
            }
            return mtStatusMessages;
        }
        Optional rongLianMtStatusMessageResults = Optional.fromNullable(rongLianMtStatusMessageResponse.getRongLianMtStatusMessageResults());
        if (!rongLianMtStatusMessageResults.isPresent()) {
            if (logger.isDebugEnabled()) {
                logger.debug("ZhongDeMtStatusMessgageResult : is null or Empty");
            }
            return mtStatusMessages;
        }
        for (RongLianMtStatusMessageResult rongLianMtStatusMessageResult : (List)rongLianMtStatusMessageResults.get()) {
            MtStatusMessage mtStatusMessage = new MtStatusMessage();
            mtStatusMessage.setSpClass(spClass);
            mtStatusMessage.setMobile(rongLianMtStatusMessageResult.getFromNum());
            mtStatusMessage.setReceiveTime(rongLianMtStatusMessageResult.getRecvTime());
            String batchId = rongLianMtStatusMessageResult.getContent();
            mtStatusMessage.setSpMessageId(mtStatusMessage.buildSpMessageId(batchId));
            if ("0".equals(rongLianMtStatusMessageResult.getStatus())) {
                mtStatusMessage.setSmsStatus(SmsStatus.TOUCH.getStatus());
            } else {
                mtStatusMessage.setSmsStatus(SmsStatus.NO_TOUCH.getStatus());
            }
            mtStatusMessages.add(mtStatusMessage);
        }
        return mtStatusMessages;
    }

    private List<MoMessage> parseResponseToMoMessages(String response, String spId) {
        ArrayList moMessages = Lists.newArrayList();
        RongLianMoMessageResponse rongLianMoMessageResponse = null;
        try {
            rongLianMoMessageResponse = (RongLianMoMessageResponse)JacksonHelper.convertJsonByClass((String)response, RongLianMoMessageResponse.class);
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("response:{} and convert to rongLianMtStatusMessageResponse:{}", (Object)response, (Object)rongLianMoMessageResponse.toString());
            }
            return moMessages;
        }
        if (rongLianMoMessageResponse == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("rongLianMoMessageResponse : is null ");
            }
            return moMessages;
        }
        Optional rongLianMoMessageResults = Optional.fromNullable(rongLianMoMessageResponse.getRongLianMoMessageResults());
        if (!rongLianMoMessageResults.isPresent()) {
            if (logger.isDebugEnabled()) {
                logger.debug("rongLianMoMessageResults is null");
            }
            return moMessages;
        }
        for (RongLianMoMessageResult rongLianMoMessageResult : (List)rongLianMoMessageResults.get()) {
            MoMessage moMessage = new MoMessage();
            moMessage.setSpId(spId);
            moMessage.setContent(rongLianMoMessageResult.getContent());
            moMessage.setMobile(rongLianMoMessageResult.getFromNum());
            moMessage.setReceiveTime(rongLianMoMessageResult.getRecvTime());
            moMessages.add(moMessage);
        }
        return moMessages;
    }

    public List<MtResult> sendVoiceMessage(String apiUrl, String appId, String accountSid, String token, List<SmsMessage> smsMessages) throws IOException {
        Assert.notNull((Object)apiUrl, (String)"apiUrl could'nt be null");
        Assert.notNull((Object)appId, (String)"appId could'nt be null");
        Assert.notNull((Object)accountSid, (String)"accountSid could'nt be null");
        Assert.notNull((Object)token, (String)"token could'nt be null");
        Assert.notEmpty(smsMessages, (String)"smsMessages could'nt be null");
        SmsMessage smsMessage = smsMessages.get(0);
        Assert.notNull((Object)smsMessage, (String)"smsMessage could'nt be null");
        RongLianVoiceRequest voiceRequest = new RongLianVoiceRequest();
        voiceRequest.setAppId(appId);
        voiceRequest.setContent(smsMessage.getContent());
        voiceRequest.setMobile(smsMessage.getMobile());
        String timeStamp = this.getTimestamp();
        Map<String, String> headers = voiceRequest.getHeaders(timeStamp, accountSid);
        String sigParameter = SignUtils.md5((String)(accountSid + token + timeStamp), (String)DEFAULT_CHARSET);
        String url = MessageFormat.format(apiUrl, accountSid, VOICE_ACTION, sigParameter);
        String json = JacksonHelper.getJsonString((Object)voiceRequest);
        String response = ParameteredHttpUtils.doPost(this.rongLianVoiceRequestHttpParameterHandler, headers, (String)json, (String)url, (String)DEFAULT_CHARSET, (int)10000);
        List<MtResult> mtResults = this.parseVoiceResponse(response, smsMessages);
        return mtResults;
    }

    private List<MtResult> parseMessageResponse(String response, List<SmsMessage> smsMessages) throws IOException {
        RongLianMessageResponse rongLianMessageResponse = (RongLianMessageResponse)JacksonHelper.convertJsonByClass((String)response, RongLianMessageResponse.class);
        Assert.notNull((Object)rongLianMessageResponse, (String)"rongLianMessageResponse can not null");
        boolean flag = rongLianMessageResponse.isStatusSuccess();
        if (flag) {
            RongLianMessageResult rongLianMessageResult = rongLianMessageResponse.getMessageResult();
            Assert.notNull((Object)rongLianMessageResult, (String)"rongLianMessageResult can not null");
            if (logger.isDebugEnabled()) {
                logger.debug("Succeed to send request: {} and response is: {}", smsMessages, (Object)response);
            }
            String spMessageId = rongLianMessageResult.getSmsMessageSid();
            return MtResult.buildMtResult(smsMessages, (SmsStatus)SmsStatus.SUCCESS, (String)spMessageId);
        }
        if (logger.isDebugEnabled()) {
            logger.info("Failed to send request: {} and response is: {}", smsMessages, (Object)response);
        }
        return MtResult.buildMtResult(smsMessages, (SmsStatus)SmsStatus.FAIL, null);
    }

    private List<MtResult> parseVoiceResponse(String response, List<SmsMessage> smsMessages) throws IOException {
        RongLianVoiceResponse rongLianVoiceResponse = (RongLianVoiceResponse)JacksonHelper.convertJsonByClass((String)response, RongLianVoiceResponse.class);
        Assert.notNull((Object)rongLianVoiceResponse, (String)"rongLianMessageResponse can not null");
        boolean flag = rongLianVoiceResponse.isStatusSuccess();
        if (flag) {
            RongLianVoiceResult messageResult = rongLianVoiceResponse.getRongLianVoiceResult();
            Assert.notNull((Object)messageResult, (String)"messageResult can not null");
            String spMessageId = messageResult.getCallSid();
            if (logger.isDebugEnabled()) {
                logger.debug("Succeed to send request: {} and response is: {}", smsMessages, (Object)response);
            }
            return MtResult.buildMtResult(smsMessages, (SmsStatus)SmsStatus.SUCCESS, (String)spMessageId);
        }
        if (logger.isDebugEnabled()) {
            logger.info("Failed to send request: {} and response is: {}", smsMessages, (Object)response);
        }
        return MtResult.buildMtResult(smsMessages, (SmsStatus)SmsStatus.FAIL, null);
    }

    private String mergeMobiles(List<SmsMessage> smsMessages) {
        String delimiter = "";
        StringBuffer mobiles = new StringBuffer();
        for (SmsMessage smsMessage : smsMessages) {
            mobiles.append(delimiter).append(smsMessage.getMobile());
            delimiter = REGEX;
        }
        return mobiles.toString();
    }

    private String getTimestamp() {
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_STRING);
        return format.format(new Date());
    }
}

