/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.client.sp.ronglian;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.xunlei.channel.sms.client.AbstractBatchModeSpClient;
import com.xunlei.channel.sms.client.SpNotSupportModeException;
import com.xunlei.channel.sms.client.constant.SpBatchMode;
import com.xunlei.channel.sms.client.sp.ronglian.client.RongLianClient;
import com.xunlei.channel.sms.entity.MtResult;
import com.xunlei.channel.sms.entity.SpInfo;
import com.xunlei.channel.sms.util.JacksonHelper;
import com.xunlei.channel.sms.vo.MoMessage;
import com.xunlei.channel.sms.vo.MtStatusMessage;
import com.xunlei.channel.sms.vo.SmsMessage;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RongLianSpClient
extends AbstractBatchModeSpClient {
    private static final Logger logger = LoggerFactory.getLogger(RongLianSpClient.class);
    private RongLianClient rongLianClient = new RongLianClient();
    private static final String EXT_JSON_RONGLIAN = "ronglian";
    private static final String ZERO = "0";

    @Override
    public String spClass() {
        return EXT_JSON_RONGLIAN;
    }

    @Override
    protected int maxSameContentBatchSize() {
        return 200;
    }

    @Override
    protected int maxDifferentContentBatchSize() {
        return 0;
    }

    @Override
    protected SpBatchMode[] supportBatchModes() {
        return new SpBatchMode[]{SpBatchMode.SAME_CONTENT};
    }

    @Override
    protected MtResult singleSend(SpInfo spInfo, SmsMessage message) throws Exception {
        throw new SpNotSupportModeException();
    }

    @Override
    protected List<MtResult> sendMultiplyContents(SpInfo spInfo, List<SmsMessage> messages) throws Exception {
        throw new SpNotSupportModeException();
    }

    @Override
    protected List<MtResult> sendSameContentWithMobiles(SpInfo spInfo, List<SmsMessage> messages) throws Exception {
        String apiUrl = spInfo.getApiUrl();
        String accountSid = spInfo.getAccount();
        String appId = spInfo.getExt1();
        String templateId = spInfo.getExt2();
        String token = spInfo.getExt3();
        List<MtResult> mtResult = null;
        String extJson = messages.get(0).getExtJson();
        if (StringUtils.isEmpty((Object)extJson)) {
            mtResult = this.rongLianClient.sendMessage(apiUrl, appId, templateId, accountSid, token, messages);
        } else {
            Map stateMap = JacksonHelper.convertJsonToMapByRawType((String)extJson, String.class, String.class);
            String state = (String)stateMap.get(EXT_JSON_RONGLIAN);
            if (ZERO.equals(state)) {
                mtResult = this.rongLianClient.sendVoiceMessage(apiUrl, appId, accountSid, token, messages);
            }
        }
        return mtResult;
    }

    @Override
    public List<MtStatusMessage> getMtStatusMessages(String spId) {
        Optional<SpInfo> spInfoBySpId = this.getSpInfoBySpId(spId);
        if (!spInfoBySpId.isPresent()) {
            logger.error("Not found available for spId: {}", (Object)spId);
            return null;
        }
        SpInfo spInfo = (SpInfo)spInfoBySpId.get();
        String apiUrl = spInfo.getApiUrl();
        String accountSid = spInfo.getAccount();
        String appId = spInfo.getExt1();
        String token = spInfo.getExt3();
        String spClass = spInfo.getSpClass();
        List<Object> mtStatusMessages = Lists.newArrayList();
        try {
            mtStatusMessages = this.rongLianClient.getMtStatusMessages(apiUrl, appId, accountSid, token, spClass);
        }
        catch (Exception e) {
            logger.error("Failed to getMtStatusMessages with message: " + e.getMessage(), (Throwable)e);
        }
        return mtStatusMessages;
    }

    @Override
    public List<MoMessage> getMoMessages(String spId) {
        Optional<SpInfo> spInfoBySpId = this.getSpInfoBySpId(spId);
        if (!spInfoBySpId.isPresent()) {
            logger.error("Not found available for spId: {}", (Object)spId);
            return null;
        }
        SpInfo spInfo = (SpInfo)spInfoBySpId.get();
        String apiUrl = spInfo.getApiUrl();
        String accountSid = spInfo.getAccount();
        String appId = spInfo.getExt1();
        String token = spInfo.getExt3();
        List<Object> moMessages = Lists.newArrayList();
        try {
            moMessages = this.rongLianClient.getMoMessages(apiUrl, appId, accountSid, token, spId);
        }
        catch (Exception e) {
            logger.error("Failed to getMtStatusMessages with message: " + e.getMessage(), (Throwable)e);
        }
        return moMessages;
    }
}

