/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.sms.client.sp.mongate.vo;

import com.xunlei.channel.sms.client.sp.mongate.vo.MongateMultiContentRequestUnit;
import com.xunlei.channel.sms.util.http.annotation.HttpParameter;
import com.xunlei.channel.sms.util.http.annotation.ParameterIgnore;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongateMultiContentRequest {
    private static final Logger logger = LoggerFactory.getLogger(MongateMultiContentRequest.class);
    public static final String UNIT_FIELDS_DELIMITER = "|";
    public static final String PACKAGE_DELIMITER = ",";
    private String userId;
    private String password;
    @ParameterIgnore
    private List<MongateMultiContentRequestUnit> units;
    @HttpParameter(value="multix_mt")
    private String multiContentPackage;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<MongateMultiContentRequestUnit> getUnits() {
        return this.units;
    }

    public void setUnits(List<MongateMultiContentRequestUnit> units) throws Exception {
        this.units = units;
        this.parseMultiContentPackage();
    }

    public String parseMultiContentPackage() throws Exception {
        StringBuilder builder = new StringBuilder();
        Iterator<MongateMultiContentRequestUnit> iterator = this.units.iterator();
        while (iterator.hasNext()) {
            MongateMultiContentRequestUnit unit = iterator.next();
            String packageContent = unit.toPackageContent();
            builder.append(packageContent);
            if (!iterator.hasNext()) continue;
            builder.append(PACKAGE_DELIMITER);
        }
        this.multiContentPackage = builder.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("Parse object: {} to package: {}", (Object)this, (Object)this.multiContentPackage);
        }
        return this.multiContentPackage;
    }

    public String getMultiContentPackage() {
        return this.multiContentPackage;
    }

    public void setMultiContentPackage(String multiContentPackage) {
        this.multiContentPackage = multiContentPackage;
    }
}

